/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class BaseModel {
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Object getValue(String key) throws NoSuchElementException {
        Field field = this.getFieldMatchingKey(key);
        if (field != null) {
            try {
                return field.get(this);
            }
            catch (Exception ex) {
                return null;
            }
        }
        Method method = this.getMethodMatchingKey(key, true);
        if (method != null) {
            try {
                return method.invoke((Object)this, new Object[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (this.additionalProperties.containsKey(key)) {
            return this.additionalProperties.get(key);
        }
        throw new NoSuchElementException("Value not found with the given key: " + key);
    }

    public void setValue(String key, Object value) {
        Field field;
        Method method = this.getMethodMatchingKey(key, false);
        if (method != null) {
            try {
                method.invoke((Object)this, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((field = this.getFieldMatchingKey(key)) != null) {
            try {
                field.set(this, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.additionalProperties.containsKey(key)) {
            this.additionalProperties.put(key, value);
        }
    }

    private Field getFieldMatchingKey(String key) {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(key)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private Method getMethodMatchingKey(String key, boolean getter) {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            Object annotation = getter ? method.getAnnotation(JsonGetter.class) : method.getAnnotation(JsonSetter.class);
            if (annotation == null) continue;
            String methodName = key;
            if (getter && annotation.value().equalsIgnoreCase(methodName.replace("get", ""))) {
                return method;
            }
            if (getter || !((JsonSetter)annotation).value().equalsIgnoreCase(methodName.replace("set", ""))) continue;
            return method;
        }
        return null;
    }
}

