/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import com.google.common.collect.Streams;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.manager.api.beans.actions.ContractActionDto;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.contracts.ContractStatus;
import io.apiman.manager.api.beans.events.ApimanEventHeaders;
import io.apiman.manager.api.beans.events.ContractApprovalEvent;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.idm.UserMapper;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IClientValidator;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.events.EventService;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.exceptions.ActionException;
import io.apiman.manager.api.rest.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidContractStatusException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ClientAppService;
import io.apiman.manager.api.service.ContractService;
import io.apiman.manager.api.service.PlanService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jetbrains.annotations.NotNull;

@Transactional
@ApplicationScoped
public class ActionService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ActionService.class);
    private final UserMapper userMapper = UserMapper.INSTANCE;
    private IStorage storage;
    private ISecurityContext securityContext;
    private PlanService planService;
    private ContractService contractService;
    private IStorageQuery query;
    private EventService eventService;
    private ClientAppService clientAppService;
    private IClientValidator clientValidator;
    private IGatewayLinkFactory gatewayLinkFactory;

    @Inject
    public ActionService(IStorage storage, ISecurityContext securityContext, PlanService planService, IStorageQuery query, ContractService contractService, EventService eventService, ClientAppService clientAppService, IClientValidator clientValidator, IGatewayLinkFactory gatewayLinkFactory) {
        this.storage = storage;
        this.securityContext = securityContext;
        this.planService = planService;
        this.query = query;
        this.contractService = contractService;
        this.eventService = eventService;
        this.clientAppService = clientAppService;
        this.clientValidator = clientValidator;
        this.gatewayLinkFactory = gatewayLinkFactory;
    }

    public ActionService() {
    }

    public void rejectContract(ContractActionDto action, String rejectorId) {
        ContractBean contract = this.getContractById(action.getContractId());
        ClientVersionBean cvb = contract.getClient();
        ApiVersionBean avb = contract.getApi();
        PlanVersionBean plan = contract.getPlan();
        OrganizationBean orgA = avb.getApi().getOrganization();
        OrganizationBean orgC = cvb.getClient().getOrganization();
        UserBean rejector = this.tryAction(() -> this.storage.getUser(rejectorId));
        contract.setStatus(ContractStatus.Rejected);
        this.fireContractRejectedEvent(rejector, action.getRejectionReason(), contract, orgC, cvb, orgA, avb, plan);
        this.contractService.deleteContract(orgC.getId(), cvb.getClient().getId(), cvb.getVersion(), contract.getId());
        LOGGER.debug("{0} rejected a contract: {1} -> {2}", new Object[]{rejectorId, contract, action});
    }

    public void approveContract(ContractActionDto action, String approverId) {
        ContractBean contract = this.getContractById(action.getContractId());
        ClientVersionBean cvb = contract.getClient();
        ApiVersionBean avb = contract.getApi();
        OrganizationBean org = avb.getApi().getOrganization();
        PlanVersionBean plan = contract.getPlan();
        OrganizationBean orgA = avb.getApi().getOrganization();
        OrganizationBean orgC = cvb.getClient().getOrganization();
        UserBean approver = this.tryAction(() -> this.storage.getUser(approverId));
        contract.setStatus(ContractStatus.Created);
        LOGGER.debug("{0} approved a contract: {1} -> {2}", new Object[]{approverId, contract, action});
        List contracts = this.tryAction(() -> Streams.stream((Iterator)this.storage.getAllContracts(org.getId(), cvb.getClient().getId(), cvb.getVersion()))).collect(Collectors.toList());
        List awaitingApprovalList = contracts.stream().filter(c -> c.getStatus().equals((Object)ContractStatus.AwaitingApproval)).collect(Collectors.toList());
        if (awaitingApprovalList.size() > 0) {
            LOGGER.debug("A contract was approved, but {0} other contracts are still awaiting approval, so client version {1} will remain in its pending state until the remaining contract approvals are granted: {2}.", new Object[]{awaitingApprovalList.size(), cvb.getVersion(), awaitingApprovalList});
        } else {
            LOGGER.debug("All contracts for {0} have been approved", new Object[]{cvb.getVersion()});
            this.tryAction(() -> {
                if (this.clientValidator.isReady(cvb)) {
                    LOGGER.debug("Client set to ready as all contracts have been approved");
                    cvb.setStatus(ClientStatus.Ready);
                    this.clientAppService.fireClientStatusChangeEvent(cvb, ClientStatus.AwaitingApproval);
                    if (action.isAutoPromote()) {
                        LOGGER.debug("Auto approving: {0}", new Object[]{cvb});
                        this.registerClient(orgC.getId(), cvb.getClient().getId(), cvb.getVersion());
                    }
                }
            });
        }
        this.fireContractApprovedEvent(approver, contract, orgC, cvb, orgA, avb, plan);
    }

    @NotNull
    private ContractBean getContractById(Long contractId) throws ActionException, InvalidContractStatusException {
        ContractBean contract = this.tryAction(() -> this.storage.getContract(contractId));
        if (contract == null) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ContractDoesNotExist", new Object[0]));
        }
        if (contract.getStatus() != ContractStatus.AwaitingApproval) {
            throw ExceptionFactory.invalidContractStatus((ContractStatus)ContractStatus.AwaitingApproval, (ContractStatus)contract.getStatus());
        }
        return contract;
    }

    private void fireContractRejectedEvent(UserBean rejector, String rejectionReason, ContractBean contract, OrganizationBean orgC, ClientVersionBean cvb, OrganizationBean orgA, ApiVersionBean avb, PlanVersionBean plan) {
        ApimanEventHeaders headers = ApimanEventHeaders.builder().setId(UUID.randomUUID().toString().substring(8)).setSource(URI.create("/apiman/events/contracts/approvals")).setSubject("rejection").build();
        ContractApprovalEvent event = ContractApprovalEvent.builder().setApprover(this.userMapper.toDto(rejector)).setApproved(Boolean.valueOf(false)).setRejectionReason(rejectionReason).setHeaders(headers).setClientOrgId(orgC.getId()).setClientId(cvb.getClient().getId()).setClientVersion(cvb.getVersion()).setApiOrgId(orgA.getId()).setApiId(avb.getApi().getId()).setApiVersion(avb.getVersion()).setContractId(String.valueOf(contract.getId())).setPlanId(plan.getPlan().getId()).setPlanVersion(plan.getVersion()).build();
        LOGGER.debug("Sending contract rejected response event: {0}", new Object[]{event});
        this.eventService.fireEvent(event);
    }

    private void fireContractApprovedEvent(UserBean approver, ContractBean contract, OrganizationBean orgC, ClientVersionBean cvb, OrganizationBean orgA, ApiVersionBean avb, PlanVersionBean plan) {
        ApimanEventHeaders headers = ApimanEventHeaders.builder().setId(UUID.randomUUID().toString().substring(8)).setSource(URI.create("/apiman/events/contracts/approvals")).setSubject("approval").build();
        ContractApprovalEvent event = ContractApprovalEvent.builder().setApprover(this.userMapper.toDto(approver)).setApproved(Boolean.valueOf(true)).setHeaders(headers).setClientOrgId(orgC.getId()).setClientId(cvb.getClient().getId()).setClientVersion(cvb.getVersion()).setApiOrgId(orgA.getId()).setApiId(avb.getApi().getId()).setApiVersion(avb.getVersion()).setContractId(String.valueOf(contract.getId())).setPlanId(plan.getPlan().getId()).setPlanVersion(plan.getVersion()).build();
        LOGGER.debug("Sending contract approval response event: {0}", new Object[]{event});
        this.eventService.fireEvent(event);
    }

    public void publishApi(String orgId, String apiId, String apiVersion) throws ActionException, NotAuthorizedException {
        ApiVersionBean versionBean;
        try {
            versionBean = this.storage.getApiVersion(orgId, apiId, apiVersion);
        }
        catch (ApiVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiNotFound", new Object[0]));
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (!versionBean.isPublicAPI() && versionBean.getStatus() != ApiStatus.Ready) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
        }
        if (versionBean.isPublicAPI()) {
            Date publishedOn;
            Date modOn;
            int c;
            if (versionBean.getStatus() == ApiStatus.Retired || versionBean.getStatus() == ApiStatus.Created) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
            }
            if (versionBean.getStatus() == ApiStatus.Published && (c = (modOn = versionBean.getModifiedOn()).compareTo(publishedOn = versionBean.getPublishedOn())) <= 0) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiRePublishNotRequired", new Object[0]));
            }
        }
        Api gatewayApi = new Api();
        gatewayApi.setEndpoint(versionBean.getEndpoint());
        gatewayApi.setEndpointType(versionBean.getEndpointType().toString());
        if (versionBean.getEndpointContentType() != null) {
            gatewayApi.setEndpointContentType(versionBean.getEndpointContentType().toString());
        }
        gatewayApi.setEndpointProperties(versionBean.getEndpointProperties());
        gatewayApi.setOrganizationId(versionBean.getApi().getOrganization().getId());
        gatewayApi.setApiId(versionBean.getApi().getId());
        gatewayApi.setVersion(versionBean.getVersion());
        gatewayApi.setPublicAPI(versionBean.isPublicAPI());
        gatewayApi.setParsePayload(versionBean.isParsePayload());
        gatewayApi.setKeysStrippingDisabled(versionBean.getDisableKeysStrip());
        try {
            if (versionBean.isPublicAPI()) {
                ArrayList<Policy> policiesToPublish = new ArrayList<Policy>();
                List apiPolicies = this.query.getPolicies(orgId, apiId, apiVersion, PolicyType.Api);
                for (PolicySummaryBean policySummaryBean : apiPolicies) {
                    PolicyBean apiPolicy = this.storage.getPolicy(PolicyType.Api, orgId, apiId, apiVersion, policySummaryBean.getId());
                    Policy policyToPublish = new Policy();
                    policyToPublish.setPolicyJsonConfig(apiPolicy.getConfiguration());
                    policyToPublish.setPolicyImpl(apiPolicy.getDefinition().getPolicyImpl());
                    policiesToPublish.add(policyToPublish);
                }
                gatewayApi.setApiPolicies(policiesToPublish);
            }
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PublishError", new Object[0]), (Exception)((Object)e));
        }
        try {
            Set gateways = versionBean.getGateways();
            if (gateways == null) {
                throw new PublishingException("No gateways specified for API!");
            }
            for (ApiGatewayBean apiGatewayBean : gateways) {
                IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                gatewayLink.publishApi(gatewayApi);
                gatewayLink.close();
            }
            versionBean.setStatus(ApiStatus.Published);
            versionBean.setPublishedOn(new Date());
            ApiBean api = this.storage.getApi(orgId, apiId);
            if (api == null) {
                throw new PublishingException("Error: could not find API - " + orgId + "=>" + apiId);
            }
            if (api.getNumPublished() == null) {
                api.setNumPublished(Integer.valueOf(1));
            } else {
                api.setNumPublished(Integer.valueOf(api.getNumPublished() + 1));
            }
            this.storage.updateApi(api);
            this.storage.updateApiVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.apiPublished(versionBean, this.securityContext));
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PublishError", new Object[0]), (Exception)e);
        }
        LOGGER.debug(String.format("Successfully published API %s on specified gateways: %s", versionBean.getApi().getName(), versionBean.getApi()));
    }

    private IGatewayLink createGatewayLink(String gatewayId) throws PublishingException {
        try {
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw new GatewayNotFoundException();
            }
            return this.gatewayLinkFactory.create(gateway);
        }
        catch (GatewayNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PublishingException(e.getMessage(), (Throwable)e);
        }
    }

    public void retireApi(String orgId, String apiId, String apiVersion) throws ActionException, NotAuthorizedException {
        ApiVersionBean versionBean;
        try {
            versionBean = this.storage.getApiVersion(orgId, apiId, apiVersion);
        }
        catch (ApiVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiNotFound", new Object[0]));
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (versionBean.getStatus() != ApiStatus.Published) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
        }
        Api gatewayApi = new Api();
        gatewayApi.setOrganizationId(versionBean.getApi().getOrganization().getId());
        gatewayApi.setApiId(versionBean.getApi().getId());
        gatewayApi.setVersion(versionBean.getVersion());
        try {
            Set gateways = versionBean.getGateways();
            if (gateways == null) {
                throw new PublishingException("No gateways specified for API!");
            }
            for (ApiGatewayBean apiGatewayBean : gateways) {
                IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                gatewayLink.retireApi(gatewayApi);
                gatewayLink.close();
            }
            versionBean.setStatus(ApiStatus.Retired);
            versionBean.setRetiredOn(new Date());
            ApiBean api = this.storage.getApi(orgId, apiId);
            if (api == null) {
                throw new PublishingException("Error: could not find API - " + orgId + "=>" + apiId);
            }
            if (api.getNumPublished() == null || api.getNumPublished() == 0) {
                api.setNumPublished(Integer.valueOf(0));
            } else {
                api.setNumPublished(Integer.valueOf(api.getNumPublished() - 1));
            }
            this.storage.updateApi(api);
            this.storage.updateApiVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.apiRetired(versionBean, this.securityContext));
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RetireError", new Object[0]), (Exception)e);
        }
        LOGGER.debug(String.format("Successfully retired API %s on specified gateways: %s", versionBean.getApi().getName(), versionBean.getApi()));
    }

    public void registerClient(String orgId, String clientId, String clientVersion) throws ActionException, NotAuthorizedException {
        List contractBeans;
        ClientVersionBean versionBean;
        try {
            versionBean = this.clientAppService.getClientVersion(orgId, clientId, clientVersion);
        }
        catch (ClientVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("clientVersionDoesNotExist", new Object[]{clientId, clientVersion}));
        }
        try {
            contractBeans = this.query.getClientContracts(orgId, clientId, clientVersion);
            List awaitingApproval = contractBeans.stream().filter(f -> f.getStatus() == ContractStatus.AwaitingApproval).collect(Collectors.toList());
            if (!awaitingApproval.isEmpty()) {
                throw ExceptionFactory.contractNotYetApprovedException(awaitingApproval);
            }
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]), (Exception)((Object)e));
        }
        boolean isReregister = false;
        if (versionBean.getStatus() == ClientStatus.Registered) {
            Date publishedOn;
            Date modOn = versionBean.getModifiedOn();
            int c = modOn.compareTo(publishedOn = versionBean.getPublishedOn());
            if (c <= 0) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientReRegisterNotRequired", new Object[0]));
            }
            isReregister = true;
        }
        Client client = new Client();
        client.setOrganizationId(versionBean.getClient().getOrganization().getId());
        client.setClientId(versionBean.getClient().getId());
        client.setVersion(versionBean.getVersion());
        client.setApiKey(versionBean.getApikey());
        HashSet<Contract> contracts = new HashSet<Contract>();
        for (Object contractBean : contractBeans) {
            Contract contract = new Contract();
            contract.setPlan(contractBean.getPlanId());
            contract.setApiId(contractBean.getApiId());
            contract.setApiOrgId(contractBean.getApiOrganizationId());
            contract.setApiVersion(contractBean.getApiVersion());
            contract.getPolicies().addAll(this.contractService.aggregateContractPolicies((ContractSummaryBean)contractBean));
            contracts.add(contract);
        }
        client.setContracts(contracts);
        try {
            HashMap<String, IGatewayLink> links = new HashMap<String, IGatewayLink>();
            for (Contract contract : client.getContracts()) {
                ApiVersionBean svb = this.storage.getApiVersion(contract.getApiOrgId(), contract.getApiId(), contract.getApiVersion());
                Set gateways = svb.getGateways();
                if (gateways == null) {
                    throw new PublishingException("No gateways specified for API: " + svb.getApi().getName());
                }
                for (ApiGatewayBean apiGatewayBean : gateways) {
                    if (links.containsKey(apiGatewayBean.getGatewayId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                    links.put(apiGatewayBean.getGatewayId(), gatewayLink);
                }
            }
            if (isReregister) {
                Iterator gateways = this.storage.getAllGateways();
                while (gateways.hasNext()) {
                    GatewayBean gbean = (GatewayBean)gateways.next();
                    if (links.containsKey(gbean.getId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(gbean.getId());
                    try {
                        gatewayLink.unregisterClient(client);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    gatewayLink.close();
                }
            }
            for (IGatewayLink gatewayLink : links.values()) {
                gatewayLink.registerClient(client);
                gatewayLink.close();
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RegisterError", new Object[0]), (Exception)e);
        }
        ClientStatus oldStatus = versionBean.getStatus();
        versionBean.setStatus(ClientStatus.Registered);
        versionBean.setPublishedOn(new Date());
        try {
            this.storage.updateClientVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.clientRegistered(versionBean, this.securityContext));
            this.clientAppService.fireClientStatusChangeEvent(versionBean, oldStatus);
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RegisterError", new Object[0]), (Exception)e);
        }
        LOGGER.debug(String.format("Successfully registered Client %s on specified gateways: %s", versionBean.getClient().getName(), versionBean.getClient()));
    }

    public void unregisterClient(String orgId, String clientId, String clientVersion) throws ActionException, NotAuthorizedException {
        List contractBeans;
        ClientVersionBean versionBean;
        try {
            versionBean = this.clientAppService.getClientVersion(orgId, clientId, clientVersion);
        }
        catch (ClientVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]));
        }
        try {
            contractBeans = this.query.getClientContracts(orgId, clientId, clientVersion).stream().peek(c -> {
                if (c.getStatus() != ContractStatus.Created) {
                    LOGGER.debug("Will not try to delete contract {0} from gateway(s) as it is not in 'Created' state", new Object[]{c});
                }
            }).filter(c -> c.getStatus() == ContractStatus.Created).collect(Collectors.toList());
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]), (Exception)((Object)e));
        }
        if (versionBean.getStatus() != ClientStatus.Registered && versionBean.getStatus() != ClientStatus.AwaitingApproval) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidClientStatus", new Object[0]));
        }
        Client client = new Client();
        client.setOrganizationId(versionBean.getClient().getOrganization().getId());
        client.setClientId(versionBean.getClient().getId());
        client.setVersion(versionBean.getVersion());
        try {
            HashMap<String, IGatewayLink> links = new HashMap<String, IGatewayLink>();
            for (ContractSummaryBean contractBean : contractBeans) {
                ApiVersionBean svb = this.storage.getApiVersion(contractBean.getApiOrganizationId(), contractBean.getApiId(), contractBean.getApiVersion());
                Set gateways = svb.getGateways();
                if (gateways == null) {
                    throw new PublishingException("No gateways specified for API: " + svb.getApi().getName());
                }
                for (ApiGatewayBean apiGatewayBean : gateways) {
                    if (links.containsKey(apiGatewayBean.getGatewayId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                    links.put(apiGatewayBean.getGatewayId(), gatewayLink);
                }
            }
            for (IGatewayLink gatewayLink : links.values()) {
                gatewayLink.unregisterClient(client);
                gatewayLink.close();
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("UnregisterError", new Object[0]), (Exception)e);
        }
        ClientStatus oldStatus = versionBean.getStatus();
        versionBean.setStatus(ClientStatus.Retired);
        versionBean.setRetiredOn(new Date());
        this.clientAppService.fireClientStatusChangeEvent(versionBean, oldStatus);
        try {
            this.storage.updateClientVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.clientUnregistered(versionBean, this.securityContext));
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("UnregisterError", new Object[0]), (Exception)e);
        }
        LOGGER.debug(String.format("Successfully registered Client %s on specified gateways: %s", versionBean.getClient().getName(), versionBean.getClient()));
    }

    public void lockPlan(String orgId, String planId, String planVersion) throws ActionException, NotAuthorizedException {
        PlanVersionBean versionBean;
        try {
            versionBean = this.planService.getPlanVersion(orgId, planId, planVersion);
        }
        catch (PlanVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PlanNotFound", new Object[0]));
        }
        if (versionBean.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidPlanStatus", new Object[0]));
        }
        versionBean.setStatus(PlanStatus.Locked);
        versionBean.setLockedOn(new Date());
        try {
            this.storage.updatePlanVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.planLocked(versionBean, this.securityContext));
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("LockError", new Object[0]), (Exception)e);
        }
        LOGGER.debug(String.format("Successfully locked Plan %s: %s", versionBean.getPlan().getName(), versionBean.getPlan()));
    }
}

