/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.schema.format;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.Node;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.schema.format.ApiDefinitionProvider;
import io.apiman.manager.api.schema.format.OpenApi2;
import io.apiman.manager.api.schema.format.OpenApi3;
import io.apiman.manager.api.schema.format.ProviderContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class OpenApiProvider
implements ApiDefinitionProvider {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(OpenApiProvider.class);
    private static final ObjectMapper JSON_OM = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ObjectMapper YAML_OM = new ObjectMapper((JsonFactory)new YAMLFactory()).findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT);
    private static final OpenApi2 OPEN_API_2 = new OpenApi2();
    private static final OpenApi3 OPEN_API_3 = new OpenApi3();

    @Override
    public String rewrite(ProviderContext providerCtx, InputStream is, ApiDefinitionType apiDefinitionType) throws IOException, StorageException, GatewayAuthenticationException {
        JsonNode root = this.om(apiDefinitionType).readTree(is);
        if (root.has("swaggerVersion") && StringUtils.startsWith((CharSequence)root.get("swaggerVersion").asText(), (CharSequence)"1.")) {
            return this.om(apiDefinitionType).writeValueAsString((Object)root);
        }
        Document parsedLib = Library.readDocument((Object)root);
        DocumentType docType = parsedLib.getDocumentType();
        switch (docType) {
            case openapi2: {
                OPEN_API_2.rewrite(providerCtx, parsedLib);
                break;
            }
            case openapi3: {
                OPEN_API_3.rewrite(providerCtx, parsedLib);
                break;
            }
            default: {
                LOGGER.warn("We don't know how to handle {0} (yet), returning schema without doing anything", new Object[]{docType});
            }
        }
        Object writeOut = Library.writeNode((Node)parsedLib);
        return this.om(apiDefinitionType).writeValueAsString(writeOut);
    }

    private ObjectMapper om(ApiDefinitionType apiDefinitionType) {
        if (apiDefinitionType == ApiDefinitionType.SwaggerJSON) {
            return JSON_OM;
        }
        if (apiDefinitionType == ApiDefinitionType.SwaggerYAML) {
            return YAML_OM;
        }
        throw new IllegalArgumentException("This rewriter only supports SwaggerJSON or SwaggerYAML: " + apiDefinitionType);
    }
}

