/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.rest.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import java.util.HashSet;
import java.util.Set;

public final class SearchCriteriaUtil {
    protected static final Set<SearchCriteriaFilterOperator> validOperators = new HashSet<SearchCriteriaFilterOperator>();

    private SearchCriteriaUtil() {
    }

    public static void validateSearchCriteria(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        if (criteria.getPaging() != null) {
            if (criteria.getPaging().getPage() < 1) {
                throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingPage", new Object[0]));
            }
            if (criteria.getPaging().getPageSize() < 1) {
                throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingPageSize", new Object[0]));
            }
        }
        int count = 1;
        for (SearchCriteriaFilterBean filter : criteria.getFilters()) {
            if (filter.getName() == null || filter.getName().trim().length() == 0) {
                throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingSearchFilterName", new Object[]{count}));
            }
            if (filter.getValue() == null || filter.getValue().trim().length() == 0) {
                throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingSearchFilterValue", new Object[]{count}));
            }
            if (filter.getOperator() == null || !validOperators.contains(filter.getOperator())) {
                throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingSearchFilterOperator", new Object[]{count}));
            }
            ++count;
        }
        if (criteria.getOrderBy() != null && (criteria.getOrderBy().getName() == null || criteria.getOrderBy().getName().trim().length() == 0)) {
            throw new InvalidSearchCriteriaException(Messages.i18n.format("SearchCriteriaUtil.MissingOrderByName", new Object[0]));
        }
    }

    static {
        validOperators.add(SearchCriteriaFilterOperator.eq);
        validOperators.add(SearchCriteriaFilterOperator.gt);
        validOperators.add(SearchCriteriaFilterOperator.gte);
        validOperators.add(SearchCriteriaFilterOperator.lt);
        validOperators.add(SearchCriteriaFilterOperator.lte);
        validOperators.add(SearchCriteriaFilterOperator.neq);
        validOperators.add(SearchCriteriaFilterOperator.like);
    }
}

