/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email;

import io.apiman.common.config.options.GenericOptionsParser;
import io.apiman.common.config.options.Predicates;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class SmtpEmailConfiguration
extends GenericOptionsParser {
    public static final String PREFIX = "smtp.";
    private boolean enabled;
    private boolean mock;
    private boolean ssl;
    private StartTLSEnum startTLSMode = StartTLSEnum.OPTIONAL;
    private String fromName;
    private String fromEmail;
    private String host;
    private int port;
    private String[] authMethods;
    private String username;
    private String password;

    public SmtpEmailConfiguration(Map<String, String> options) {
        super(options);
    }

    protected void parse(Map<String, String> options) {
        super.parse(options);
        this.enabled = this.getBool(SmtpEmailConfiguration.keys((Object[])new String[]{"enable"}), false);
        if (this.enabled) {
            this.mock = this.getBool(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.mock"}), false);
            this.ssl = this.getBool(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.ssl"}), true);
            this.startTLSMode = (StartTLSEnum)this.getEnum(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.startTLSMode"}), StartTLSEnum.OPTIONAL, StartTLSEnum::toValue);
            this.fromName = this.getRequiredString(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.fromName"}), Predicates.anyOk(), "");
            this.fromEmail = this.getRequiredString(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.fromEmail"}), Predicates.anyOk(), "");
            this.host = this.getRequiredString(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.host"}), Predicates.anyOk(), "");
            this.port = this.getInt(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.port"}), 587, Predicates.greaterThanZeroInt(), Predicates.greaterThanZeroMsg());
            this.username = this.getString(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.username"}), null, Predicates.anyOk(), "");
            this.password = this.getString(SmtpEmailConfiguration.keys((Object[])new String[]{"smtp.password"}), null, Predicates.anyOk(), "");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SmtpEmailConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isMock() {
        return this.mock;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public StartTLSEnum getStartTLSMode() {
        return this.startTLSMode;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getAuthMethods() {
        return this.authMethods;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return new StringJoiner(", ", SmtpEmailConfiguration.class.getSimpleName() + "[", "]").add("enabled=" + this.enabled).add("mock=" + this.mock).add("ssl=" + this.ssl).add("startTLSMode=" + this.startTLSMode).add("fromName='" + this.fromName + "'").add("fromEmail='" + this.fromEmail + "'").add("host='" + this.host + "'").add("port=" + this.port).add("authMethods=" + Arrays.toString(this.authMethods)).add("username='xxxx'").add("password='xxxx'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SmtpEmailConfiguration that = (SmtpEmailConfiguration)((Object)o);
        return this.enabled == that.enabled && this.mock == that.mock && this.ssl == that.ssl && this.port == that.port && this.startTLSMode == that.startTLSMode && Objects.equals(this.fromName, that.fromName) && Objects.equals(this.fromEmail, that.fromEmail) && Objects.equals(this.host, that.host) && Arrays.equals(this.authMethods, that.authMethods) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.enabled, this.mock, this.ssl, this.startTLSMode, this.fromName, this.fromEmail, this.host, this.port, this.username, this.password});
        result = 31 * result + Arrays.hashCode(this.authMethods);
        return result;
    }

    public static enum StartTLSEnum {
        DISABLED,
        OPTIONAL,
        REQUIRED;


        public static StartTLSEnum toValue(String in) {
            for (StartTLSEnum value : StartTLSEnum.values()) {
                if (!value.name().equalsIgnoreCase(in)) continue;
                return value;
            }
            throw new IllegalArgumentException(MessageFormat.format("Argument {0} not a recognised value from {1}", new Object[]{in, StartTLSEnum.values()}));
        }
    }
}

