/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.micro;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IIdmStorage;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.IApimanLogger;
import io.apiman.manager.api.core.logging.JsonLoggerImpl;
import io.apiman.manager.api.core.noop.NoOpMetricsAccessor;
import io.apiman.manager.api.es.ESMetricsAccessor;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.jpa.roles.JpaIdmStorage;
import io.apiman.manager.api.micro.ManagerApiMicroServiceConfig;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;

@ApplicationScoped
public class ManagerApiMicroServiceCdiFactory {
    private static JestClient sStorageESClient;
    private static JestClient sMetricsESClient;
    private static EsStorage sESStorage;

    @Produces
    @ApimanLogger
    public static IApimanLogger provideLogger(ManagerApiMicroServiceConfig config, InjectionPoint injectionPoint) {
        ApimanLogger logger = (ApimanLogger)injectionPoint.getAnnotated().getAnnotation(ApimanLogger.class);
        Class requestorKlazz = logger.value();
        return new JsonLoggerImpl().createLogger(requestorKlazz);
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage, IPluginRegistry pluginRegistry) {
        JpaStorage storage = null;
        if ("jpa".equals(config.getStorageType())) {
            storage = jpaStorage;
        } else if ("es".equals(config.getStorageType())) {
            storage = ManagerApiMicroServiceCdiFactory.initES(config, esStorage);
        } else {
            try {
                storage = ManagerApiMicroServiceCdiFactory.createCustomComponent(IStorage.class, config.getStorageType(), config.getStorageProperties(), pluginRegistry);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error or unknown storage type: " + config.getStorageType(), t);
            }
        }
        return storage;
    }

    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(@New DefaultSecurityContext defaultSC) {
        return defaultSC;
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, @New EsStorage esStorage, IPluginRegistry pluginRegistry) {
        if ("jpa".equals(config.getStorageType())) {
            return jpaStorage;
        }
        if ("es".equals(config.getStorageType())) {
            return ManagerApiMicroServiceCdiFactory.initES(config, esStorage);
        }
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(IStorageQuery.class, config.getStorageQueryType(), config.getStorageQueryProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown storage query type: " + config.getStorageType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor(ManagerApiMicroServiceConfig config, @New NoOpMetricsAccessor noopMetrics, @New ESMetricsAccessor esMetrics, IPluginRegistry pluginRegistry) {
        ESMetricsAccessor metrics = null;
        if ("es".equals(config.getMetricsType())) {
            metrics = esMetrics;
        } else {
            try {
                metrics = ManagerApiMicroServiceCdiFactory.createCustomComponent(IMetricsAccessor.class, config.getMetricsType(), config.getMetricsProperties(), pluginRegistry);
            }
            catch (Throwable t) {
                System.err.println("Unknown apiman metrics accessor type: " + config.getMetricsType());
                metrics = noopMetrics;
            }
        }
        return metrics;
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(@New UuidApiKeyGenerator uuidApiKeyGen) {
        return uuidApiKeyGen;
    }

    @Produces
    @ApplicationScoped
    public static IIdmStorage provideIdmStorage(ManagerApiMicroServiceConfig config, @New JpaIdmStorage jpaIdmStorage, @New EsStorage esStorage, IPluginRegistry pluginRegistry) {
        if ("jpa".equals(config.getStorageType())) {
            return jpaIdmStorage;
        }
        if ("es".equals(config.getStorageType())) {
            return ManagerApiMicroServiceCdiFactory.initES(config, esStorage);
        }
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(IIdmStorage.class, config.getIdmStorageType(), config.getIdmStorageProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown IDM storage type: " + config.getIdmStorageType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="storage")
    public static JestClient provideStorageESClient(ManagerApiMicroServiceConfig config) {
        if ("es".equals(config.getStorageType()) && sStorageESClient == null) {
            sStorageESClient = ManagerApiMicroServiceCdiFactory.createStorageJestClient(config);
        }
        return sStorageESClient;
    }

    @Produces
    @ApplicationScoped
    @Named(value="metrics")
    public static JestClient provideMetricsESClient(ManagerApiMicroServiceConfig config) {
        if ("es".equals(config.getMetricsType()) && sMetricsESClient == null) {
            sMetricsESClient = ManagerApiMicroServiceCdiFactory.createMetricsJestClient(config);
        }
        return sMetricsESClient;
    }

    private static JestClient createStorageJestClient(ManagerApiMicroServiceConfig config) {
        StringBuilder builder = new StringBuilder();
        builder.append(config.getStorageESProtocol());
        builder.append("://");
        builder.append(config.getStorageESHost());
        builder.append(":");
        builder.append(config.getStorageESPort());
        String connectionUrl = builder.toString();
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder httpConfig = (HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true);
        String username = config.getStorageESUsername();
        String password = config.getStorageESPassword();
        if (username != null) {
            httpConfig.defaultCredentials(username, password);
        }
        factory.setHttpClientConfig(httpConfig.build());
        return factory.getObject();
    }

    private static JestClient createMetricsJestClient(ManagerApiMicroServiceConfig config) {
        StringBuilder builder = new StringBuilder();
        builder.append(config.getMetricsESProtocol());
        builder.append("://");
        builder.append(config.getMetricsESHost());
        builder.append(":");
        builder.append(config.getMetricsESPort());
        String connectionUrl = builder.toString();
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder httpConfig = (HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true);
        String username = config.getMetricsESUsername();
        String password = config.getMetricsESPassword();
        if (username != null) {
            httpConfig.defaultCredentials(username, password);
        }
        factory.setHttpClientConfig(httpConfig.build());
        return factory.getObject();
    }

    private static EsStorage initES(ManagerApiMicroServiceConfig config, EsStorage esStorage) {
        if (sESStorage == null) {
            sESStorage = esStorage;
            if (config.isInitializeStorageES()) {
                sESStorage.initialize();
            }
        }
        return sESStorage;
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry) throws Exception {
        if (componentSpec == null) {
            throw new IllegalArgumentException("Null component type.");
        }
        if (componentSpec.startsWith("class:")) {
            Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
        }
        if (componentSpec.startsWith("plugin:")) {
            PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
            if (coordinates == null) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            int ssidx = componentSpec.indexOf(47);
            if (ssidx == -1) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            String classname = componentSpec.substring(ssidx + 1);
            Plugin plugin = pluginRegistry.loadPlugin(coordinates);
            PluginClassLoader classLoader = plugin.getLoader();
            Class class1 = classLoader.loadClass(classname);
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, class1, configProperties);
        }
        Class c = ReflectionUtils.loadClass((String)componentSpec);
        return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
    }

    private static <T> T createCustomComponent(Class<T> componentType, Class<?> componentClass, Map<String, String> configProperties) throws Exception {
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component spec (class not found).");
        }
        try {
            Constructor<?> constructor = componentClass.getConstructor(Map.class);
            return (T)constructor.newInstance(configProperties);
        }
        catch (Exception exception) {
            return (T)componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

