/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.micro;

import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.logging.IApimanLogger;
import io.apiman.manager.api.jpa.IJpaProperties;
import io.apiman.manager.api.micro.ManagerApiMicroService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;

@ApplicationScoped
public class ManagerApiMicroServiceConfig
extends ApiManagerConfig
implements IJpaProperties {
    public static final String APIMAN_PROPERTIES_URL = "apiman.micro.manager.properties-url";
    public static final String APIMAN_PLUGIN_DIRECTORY = "apiman.plugins.plugin-directory";
    @Inject
    @ApimanLogger(value=ManagerApiMicroService.class)
    private IApimanLogger log;

    protected Configuration loadProperties() {
        CompositeConfiguration config = (CompositeConfiguration)super.loadProperties();
        try {
            String propsUrl = System.getProperty(APIMAN_PROPERTIES_URL);
            if (propsUrl == null) {
                propsUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("micro-apiman.properties").toString();
            }
            config.addConfiguration((Configuration)new PropertiesConfiguration(new URL(propsUrl)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return config;
    }

    public File getPluginDirectory() {
        String pluginDirPath = this.getConfig().getString(APIMAN_PLUGIN_DIRECTORY, null);
        try {
            if (pluginDirPath == null) {
                File tempFile = File.createTempFile("apiman", "plugins");
                if (tempFile.isFile()) {
                    tempFile.delete();
                }
                tempFile.mkdirs();
                pluginDirPath = tempFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File pluginsDir = new File(pluginDirPath);
        return pluginsDir;
    }

    public Map<String, String> getAllHibernateProperties() {
        HashMap<String, String> rval = new HashMap<String, String>();
        Iterator keys = this.getConfig().getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("apiman.hibernate.")) continue;
            String value = this.getConfig().getString(key);
            key = key.substring("apiman.".length());
            rval.put(key, value);
        }
        return rval;
    }
}

