/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginSpec;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class PluginUtils {
    public static final String PLUGIN_SPEC_PATH = "META-INF/apiman/plugin.json";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Set<URL> MAVEN_REPOSITORIES = new HashSet<URL>();

    private PluginUtils() {
    }

    public static Set<URL> getDefaultMavenRepositories() {
        return MAVEN_REPOSITORIES;
    }

    public static String getPluginRelativePath(PluginCoordinates coordinates) {
        StringBuilder pluginRelativePath = new StringBuilder();
        pluginRelativePath.append(coordinates.getGroupId());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getArtifactId());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getVersion());
        pluginRelativePath.append("/");
        pluginRelativePath.append(coordinates.getArtifactId());
        if (coordinates.getClassifier() != null) {
            pluginRelativePath.append("-").append(coordinates.getClassifier());
        }
        pluginRelativePath.append(".");
        pluginRelativePath.append(coordinates.getType());
        return pluginRelativePath.toString();
    }

    public static PluginSpec readPluginSpecFile(URL pluginSpec) throws IOException {
        return (PluginSpec)mapper.reader(PluginSpec.class).readValue(pluginSpec);
    }

    public static File getUserM2Repository() {
        File m2Dir;
        File userHomeDir;
        String userHome = System.getProperty("user.home");
        if (userHome != null && (userHomeDir = new File(userHome)).isDirectory() && (m2Dir = new File(userHome, ".m2/repository")).isDirectory()) {
            return m2Dir;
        }
        return null;
    }

    public static File getM2Path(File m2Dir, PluginCoordinates coordinates) {
        String artifactSubPath = PluginUtils.getMavenPath(coordinates);
        return new File(m2Dir, artifactSubPath);
    }

    public static String getMavenPath(PluginCoordinates coordinates) {
        StringBuilder artifactSubPath = new StringBuilder();
        artifactSubPath.append(coordinates.getGroupId().replace('.', '/'));
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getArtifactId());
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getVersion());
        artifactSubPath.append('/');
        artifactSubPath.append(coordinates.getArtifactId());
        artifactSubPath.append('-');
        artifactSubPath.append(coordinates.getVersion());
        if (coordinates.getClassifier() != null) {
            artifactSubPath.append('-');
            artifactSubPath.append(coordinates.getClassifier());
        }
        artifactSubPath.append('.');
        artifactSubPath.append(coordinates.getType());
        return artifactSubPath.toString();
    }

    public static boolean isSnapshot(PluginCoordinates coordinates) {
        return coordinates.getVersion().endsWith("-SNAPSHOT");
    }

    static {
        try {
            MAVEN_REPOSITORIES.add(new URL("https://repo1.maven.org/maven2/"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

