/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.kernel.ErrorCodes;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.dns.DNSResolver;
import io.apigee.trireme.kernel.dns.Types;
import io.apigee.trireme.kernel.dns.Wire;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import sun.net.util.IPAddressUtil;

public class CaresWrap
implements InternalNodeModule {
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 30;
    public static final int AF_UNSPEC = 0;

    public String getModuleName() {
        return "cares_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, CaresImpl.class);
        CaresImpl cares = (CaresImpl)cx.newObject(scope, "_caresClass");
        cares.init(runner);
        return cares;
    }

    private static class LookupFunction
    extends BaseFunction {
        private final CaresImpl cares;
        private final String type;

        public LookupFunction(CaresImpl cares, String type) {
            this.cares = cares;
            this.type = type;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String name = ArgUtils.stringArg((Object[])args, (int)0);
            Function cb = ArgUtils.functionArg((Object[])args, (int)1, (boolean)true);
            this.cares.runQuery(cx, name, this.type, cb);
            return cx.newObject(thisObj);
        }
    }

    public static class CaresImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_caresClass";
        private ScriptRunner runtime;
        private DNSResolver resolver;

        public String getClassName() {
            return CLASS_NAME;
        }

        public void init(NodeRuntime runtime) {
            this.runtime = (ScriptRunner)runtime;
            this.resolver = new DNSResolver((GenericNodeRuntime)runtime);
            this.put("AF_INET", (Scriptable)this, 2);
            this.put("AF_INET6", (Scriptable)this, 30);
            this.put("AF_UNSPEC", (Scriptable)this, 0);
            this.put("queryA", (Scriptable)this, (Object)new LookupFunction(this, "A"));
            this.put("queryAaaa", (Scriptable)this, (Object)new LookupFunction(this, "AAAA"));
            this.put("queryCname", (Scriptable)this, (Object)new LookupFunction(this, "CNAME"));
            this.put("getHostByAddr", (Scriptable)this, (Object)new LookupFunction(this, "PTR"));
            this.put("queryMx", (Scriptable)this, (Object)new LookupFunction(this, "MX"));
            this.put("queryNs", (Scriptable)this, (Object)new LookupFunction(this, "NS"));
            this.put("queryTxt", (Scriptable)this, (Object)new LookupFunction(this, "TXT"));
            this.put("querySrv", (Scriptable)this, (Object)new LookupFunction(this, "SRV"));
            this.put("queryNaptr", (Scriptable)this, (Object)new LookupFunction(this, "NAPTR"));
        }

        @JSFunction
        public static int isIP(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String addrStr = ArgUtils.stringArg((Object[])args, (int)0, null);
            if (addrStr == null || addrStr.isEmpty() || addrStr.equals("0")) {
                return 0;
            }
            if (IPAddressUtil.isIPv4LiteralAddress(addrStr)) {
                return 4;
            }
            if (IPAddressUtil.isIPv6LiteralAddress(addrStr)) {
                return 6;
            }
            return 0;
        }

        @JSFunction
        public static Object getaddrinfo(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int family;
            final String name = ArgUtils.stringArg((Object[])args, (int)0);
            int fam = ArgUtils.intArg((Object[])args, (int)1, (int)0);
            final CaresImpl self = (CaresImpl)thisObj;
            switch (fam) {
                case 0: {
                    family = 0;
                    break;
                }
                case 4: {
                    family = 2;
                    break;
                }
                case 6: {
                    family = 30;
                    break;
                }
                default: {
                    throw Utils.makeError((Context)cx, (Scriptable)self, (String)("Invalid family " + fam));
                }
            }
            final Scriptable res = cx.newObject((Scriptable)self);
            self.runtime.pin();
            self.runtime.getAsyncPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        InetAddress addr = InetAddress.getByName(name);
                        if (family == 2 && !(addr instanceof Inet4Address) || family == 30 && !(addr instanceof Inet6Address)) {
                            self.lookupCallback(-5, null, res);
                        } else {
                            self.lookupCallback(0, addr, res);
                        }
                    }
                    catch (UnknownHostException uh) {
                        self.lookupCallback(-205, null, res);
                    }
                    finally {
                        self.runtime.unPin();
                    }
                }
            });
            return res;
        }

        private void lookupCallback(final int errno, final InetAddress result, final Scriptable res) {
            this.runtime.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    Function onComplete = (Function)res.get("oncomplete", res);
                    if (onComplete == null) {
                        return;
                    }
                    if (errno == 0) {
                        Object[] results = new Object[]{result.getHostAddress()};
                        onComplete.call(cx, (Scriptable)onComplete, null, new Object[]{cx.newArray((Scriptable)CaresImpl.this, results)});
                    } else {
                        CaresImpl.this.runtime.setErrno(ErrorCodes.get().toString(errno));
                        onComplete.call(cx, (Scriptable)onComplete, null, Context.emptyArgs);
                    }
                }
            });
        }

        private void runQuery(Context cx, String name, String type, final Function callback) {
            final int typeCode = Types.get().getTypeCode(type);
            try {
                this.resolver.resolve(name, type, (IOCompletionHandler)new IOCompletionHandler<Wire>(){

                    public void ioComplete(int errCode, Wire msg) {
                        CaresImpl.this.runtime.unPin();
                        if (errCode == 0) {
                            if (msg.getAnswers().isEmpty()) {
                                CaresImpl.this.queryErrorCallback("NODATA", callback);
                            } else {
                                CaresImpl.this.querySuccessCallback(msg, typeCode, callback);
                            }
                        } else {
                            CaresImpl.this.queryErrorCallback(ErrorCodes.get().toString(errCode), callback);
                        }
                    }
                });
            }
            catch (OSException ose) {
                throw new JavaScriptException((Object)this.makeError(cx, ose.toString(), ose.getStringCode()));
            }
            this.runtime.pin();
        }

        private Object convertResult(Context cx, Wire.RR rec) {
            switch (rec.getType()) {
                case 1: 
                case 28: {
                    return ((InetAddress)rec.getResult()).getHostAddress();
                }
                case 2: 
                case 5: 
                case 12: 
                case 16: {
                    return rec.getResult();
                }
                case 15: {
                    return this.convertMx(cx, (Types.Mx)rec.getResult());
                }
                case 33: {
                    return this.convertSrv(cx, (Types.Srv)rec.getResult());
                }
                case 35: {
                    return this.convertNaptr(cx, (Types.Naptr)rec.getResult());
                }
            }
            throw new AssertionError((Object)("invalid type " + rec.getType()));
        }

        private Scriptable convertMx(Context cx, Types.Mx mx) {
            Scriptable r = cx.newObject((Scriptable)this);
            r.put("priority", r, (Object)mx.getPreference());
            r.put("exchange", r, (Object)mx.getExchange());
            return r;
        }

        private Scriptable convertSrv(Context cx, Types.Srv s) {
            Scriptable r = cx.newObject((Scriptable)this);
            r.put("priority", r, (Object)s.getPriority());
            r.put("weight", r, (Object)s.getWeight());
            r.put("port", r, (Object)s.getPort());
            r.put("name", r, (Object)s.getTarget());
            return r;
        }

        private Scriptable convertNaptr(Context cx, Types.Naptr p) {
            Scriptable r = cx.newObject((Scriptable)this);
            r.put("flags", r, (Object)p.getFlags());
            r.put("service", r, (Object)p.getService());
            r.put("regexp", r, (Object)p.getRegexp());
            r.put("replacement", r, (Object)p.getReplacement());
            r.put("order", r, (Object)p.getOrder());
            r.put("preference", r, (Object)p.getPreference());
            return r;
        }

        private void queryErrorCallback(String errno, Function callback) {
            this.runtime.setErrno(errno);
            callback.call(Context.getCurrentContext(), (Scriptable)callback, null, new Object[]{-1});
        }

        private Scriptable makeError(Context cx, String msg, String code) {
            Scriptable err = Utils.makeErrorObject((Context)cx, (Scriptable)this, (String)msg, (String)code);
            err.put("errno", err, (Object)code);
            return err;
        }

        private void querySuccessCallback(Wire msg, int requestedType, Function callback) {
            Context cx = Context.getCurrentContext();
            ArrayList<Object> jResult = new ArrayList<Object>(msg.getAnswers().size());
            for (Wire.RR rr : msg.getAnswers()) {
                if (rr.getType() != requestedType) continue;
                jResult.add(this.convertResult(cx, rr));
            }
            if (jResult.isEmpty()) {
                this.runtime.setErrno("NODATA");
                callback.call(cx, (Scriptable)callback, null, new Object[]{-1});
            } else {
                Scriptable ra = cx.newArray((Scriptable)this, jResult.toArray());
                callback.call(cx, (Scriptable)callback, null, new Object[]{Undefined.instance, ra});
            }
        }
    }
}

