/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.hub.api.codegen.OpenApi2JaxRs;
import io.apicurio.hub.api.codegen.beans.CodegenInfo;
import io.apicurio.hub.api.codegen.beans.CodegenJavaArgument;
import io.apicurio.hub.api.codegen.beans.CodegenJavaBean;
import io.apicurio.hub.api.codegen.beans.CodegenJavaInterface;
import io.apicurio.hub.api.codegen.beans.CodegenJavaMethod;
import io.apicurio.hub.api.codegen.jaxrs.CodegenTarget;
import io.apicurio.hub.api.codegen.jaxrs.InterfacesVisitor;
import io.apicurio.hub.api.codegen.jaxrs.OpenApi2CodegenVisitor;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.lang.model.element.Modifier;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class OpenApi2Thorntail
extends OpenApi2JaxRs {
    @Override
    protected void generateAll(CodegenInfo info, StringBuilder log, ZipOutputStream zipOutput) throws IOException {
        super.generateAll(info, log, zipOutput);
        if (!this.isUpdateOnly()) {
            log.append("Generating Dockerfile\r\n");
            zipOutput.putNextEntry(new ZipEntry("Dockerfile"));
            zipOutput.write(this.generateDockerfile().getBytes());
            zipOutput.closeEntry();
            log.append("Generating openshift-template.yml\r\n");
            zipOutput.putNextEntry(new ZipEntry("openshift-template.yml"));
            zipOutput.write(this.generateOpenshiftTemplate().getBytes());
            zipOutput.closeEntry();
            log.append("Generating src/main/resources/META-INF/microprofile-config.properties\r\n");
            zipOutput.putNextEntry(new ZipEntry("src/main/resources/META-INF/microprofile-config.properties"));
            zipOutput.write(this.generateMicroprofileConfigProperties().getBytes());
            zipOutput.closeEntry();
        }
    }

    @Override
    protected String generateJaxRsApplication() throws IOException {
        TypeSpec jaxRsApp = TypeSpec.classBuilder((ClassName)ClassName.get((String)this.settings.javaPackage, (String)"JaxRsApplication", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)"javax.ws.rs.core", (String)"Application", (String[])new String[0])).addAnnotation(ClassName.get((String)"javax.enterprise.context", (String)"ApplicationScoped", (String[])new String[0])).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.ws.rs", (String)"ApplicationPath", (String[])new String[0])).addMember("value", "$S", new Object[]{"/"}).build()).addJavadoc("The JAX-RS application.\n", new Object[0]).build();
        JavaFile javaFile = JavaFile.builder((String)this.settings.javaPackage, (TypeSpec)jaxRsApp).skipJavaLangImports(true).build();
        return javaFile.toString();
    }

    @Override
    protected String generateJavaInterface(CodegenInfo info, CodegenJavaInterface _interface) {
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)_interface.getPackage(), (String)_interface.getName(), (String[])new String[0]));
        String jaxRsPath = info.getContextRoot() + _interface.getPath();
        interfaceBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{jaxRsPath}).build()).addJavadoc("A JAX-RS interface.  An implementation of this interface must be provided.\n", new Object[0]);
        for (CodegenJavaMethod cgMethod : _interface.getMethods()) {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)cgMethod.getName());
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            if (cgMethod.getPath() != null) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{cgMethod.getPath()}).build());
            }
            methodBuilder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.ws.rs", (String)cgMethod.getMethod().toUpperCase(), (String[])new String[0])).build());
            if (cgMethod.getProduces() != null && !cgMethod.getProduces().isEmpty()) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Produces.class).addMember("value", "$L", new Object[]{OpenApi2Thorntail.toStringArrayLiteral(cgMethod.getProduces())}).build());
            }
            if (cgMethod.getConsumes() != null && !cgMethod.getConsumes().isEmpty()) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Consumes.class).addMember("value", "$L", new Object[]{OpenApi2Thorntail.toStringArrayLiteral(cgMethod.getConsumes())}).build());
            }
            if (cgMethod.getReturn() != null) {
                TypeName returnType = this.generateTypeName(cgMethod.getReturn().getCollection(), cgMethod.getReturn().getType(), cgMethod.getReturn().getFormat(), true, (TypeName)ClassName.get((String)"javax.ws.rs.core", (String)"Response", (String[])new String[0]));
                if (this.getSettings().reactive || cgMethod.isAsync()) {
                    returnType = this.generateReactiveTypeName(returnType);
                }
                methodBuilder.returns(returnType);
            }
            if (cgMethod.getArguments() != null && !cgMethod.getArguments().isEmpty()) {
                for (CodegenJavaArgument cgArgument : cgMethod.getArguments()) {
                    ClassName defaultParamType = ClassName.OBJECT;
                    if (cgArgument.getIn().equals("body")) {
                        defaultParamType = ClassName.get((String)"java.io", (String)"InputStream", (String[])new String[0]);
                    }
                    TypeName paramType = this.generateTypeName(cgArgument.getCollection(), cgArgument.getType(), cgArgument.getFormat(), cgArgument.getRequired(), (TypeName)defaultParamType);
                    if (cgArgument.getTypeSignature() != null) {
                        // empty if block
                    }
                    ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)paramType, (String)OpenApi2Thorntail.paramNameToJavaArgName(cgArgument.getName()), (Modifier[])new Modifier[0]);
                    if (cgArgument.getIn().equals("path")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(PathParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    if (cgArgument.getIn().equals("query")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    if (cgArgument.getIn().equals("header")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(HeaderParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    methodBuilder.addParameter(paramBuilder.build());
                }
            }
            if (cgMethod.getDescription() != null) {
                methodBuilder.addJavadoc(cgMethod.getDescription(), new Object[0]);
                methodBuilder.addJavadoc("\n", new Object[0]);
            }
            interfaceBuilder.addMethod(methodBuilder.build());
        }
        TypeSpec jaxRsInterface = interfaceBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)_interface.getPackage(), (TypeSpec)jaxRsInterface).skipJavaLangImports(true).build();
        return javaFile.toString();
    }

    @Override
    protected CodegenInfo getInfoFromApiDoc() throws IOException {
        this.document = Library.readDocumentFromJSONString((String)this.openApiDoc);
        this.document = this.preProcess(this.document);
        InterfacesVisitor iVisitor = new InterfacesVisitor();
        VisitorUtil.visitTree((Node)this.document, (IVisitor)iVisitor, (TraverserDirection)TraverserDirection.down);
        OpenApi2CodegenVisitor cgVisitor = new OpenApi2CodegenVisitor(this.settings.javaPackage, iVisitor.getInterfaces(), CodegenTarget.THORNTAIL);
        VisitorUtil.visitTree((Node)this.document, (IVisitor)cgVisitor, (TraverserDirection)TraverserDirection.down);
        CodegenInfo info = cgVisitor.getCodegenInfo();
        info.getInterfaces().forEach(iface -> iface.getMethods().forEach(method -> method.getArguments().forEach(arg -> {
            String argTypeSig = arg.getTypeSignature();
            CodegenJavaBean matchingBean = OpenApi2Thorntail.findMatchingBean(info, argTypeSig);
            if (matchingBean != null) {
                arg.setType(matchingBean.getPackage() + "." + StringUtils.capitalize((String)matchingBean.getName()));
            }
        })));
        String contextRoot = this.getContextRoot(this.document);
        if (contextRoot != null) {
            info.setContextRoot(contextRoot);
        }
        return info;
    }

    private String generateDockerfile() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("Dockerfile"), (Charset)Charset.forName("UTF-8"));
        return template.replace("$ARTIFACT_ID$", this.getSettings().artifactId);
    }

    private String generateOpenshiftTemplate() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("openshift-template.yml"), (Charset)Charset.forName("UTF-8"));
        return template.replace("$ARTIFACT_ID$", this.getSettings().artifactId);
    }

    private String generateMicroprofileConfigProperties() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("microprofile-config.properties"), (Charset)Charset.forName("UTF-8"));
        return template;
    }
}

