/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen;

import io.apicurio.hub.api.codegen.OpenApi2JaxRs;
import io.apicurio.hub.api.codegen.beans.CodegenInfo;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class OpenApi2Quarkus
extends OpenApi2JaxRs {
    @Override
    protected void generateAll(CodegenInfo info, StringBuilder log, ZipOutputStream zipOutput) throws IOException {
        super.generateAll(info, log, zipOutput);
        if (!this.isUpdateOnly() && !this.settings.codeOnly) {
            log.append("Generating Dockerfiles\r\n");
            zipOutput.putNextEntry(new ZipEntry("src/main/docker/Dockerfile.jvm"));
            zipOutput.write(this.generateDockerfileJvm().getBytes());
            zipOutput.closeEntry();
            zipOutput.putNextEntry(new ZipEntry("src/main/docker/Dockerfile.native"));
            zipOutput.write(this.generateDockerfileNative().getBytes());
            zipOutput.closeEntry();
            log.append("Generating application.properties\r\n");
            zipOutput.putNextEntry(new ZipEntry("src/main/resources/application.properties"));
            zipOutput.write(this.generateApplicationProperties().getBytes());
            zipOutput.closeEntry();
            log.append("Generating src/main/resources/META-INF/microprofile-config.properties\r\n");
            zipOutput.putNextEntry(new ZipEntry("src/main/resources/META-INF/microprofile-config.properties"));
            zipOutput.write(this.generateMicroprofileConfigProperties().getBytes());
            zipOutput.closeEntry();
        }
    }

    @Override
    protected String generateJaxRsApplication() throws IOException {
        return null;
    }

    private String generateDockerfileJvm() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("src/main/docker/Dockerfile.jvm"), (Charset)Charset.forName("UTF-8"));
        return template;
    }

    private String generateDockerfileNative() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("src/main/docker/Dockerfile.native"), (Charset)Charset.forName("UTF-8"));
        return template;
    }

    private String generateApplicationProperties() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("src/main/resources/application.properties"), (Charset)Charset.forName("UTF-8"));
        return template;
    }

    private String generateMicroprofileConfigProperties() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("src/main/resources/META-INF/microprofile-config.properties"), (Charset)Charset.forName("UTF-8"));
        return template;
    }
}

