/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.pre;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.util.LocalReferenceResolver;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;

public class OpenApiTypeInliner
extends CombinedVisitorAdapter {
    public void visitSchema(Schema node) {
        Node referencedSchemaDefNode;
        OasSchema schema = (OasSchema)node;
        LocalReferenceResolver resolver = new LocalReferenceResolver();
        if (node.$ref != null && (referencedSchemaDefNode = resolver.resolveRef(node.$ref, (Node)node)) != null) {
            OasSchema referencedSchema = (OasSchema)referencedSchemaDefNode;
            if (this.isSimpleType(referencedSchema)) {
                this.inlineSchema((OasSchema)((Oas30Schema)node), referencedSchema);
                this.markForRemoval((ExtensibleNode)referencedSchema);
            } else if (this.isInlineSchema((ExtensibleNode)referencedSchemaDefNode)) {
                this.inlineSchema(schema, (OasSchema)referencedSchemaDefNode);
                this.markForRemoval((ExtensibleNode)referencedSchemaDefNode);
            }
        }
    }

    public void visitItemsSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitPropertySchema(IPropertySchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitSchemaDefinition(IDefinition node) {
        this.visitSchema((Schema)node);
    }

    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitAllOfSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.visitSchema((Schema)node);
    }

    private boolean isSimpleType(OasSchema schemaDef) {
        if ("string".equals(schemaDef.type)) {
            return schemaDef.enum_ == null;
        }
        return "integer".equals(schemaDef.type) || "number".equals(schemaDef.type) || "boolean".equals(schemaDef.type);
    }

    private void inlineSchema(OasSchema schema, OasSchema schemaDef) {
        schema.$ref = null;
        Object serializedSchemaDef = Library.writeNode((Node)schemaDef);
        Library.readNode((Object)serializedSchemaDef, (Node)schema);
    }

    private boolean isInlineSchema(ExtensibleNode referencedSchemaDefNode) {
        Extension extension = referencedSchemaDefNode.getExtension("x-codegen-inline");
        if (extension == null) {
            return false;
        }
        return "true".equals(String.valueOf(extension.value));
    }

    private void markForRemoval(ExtensibleNode node) {
        Extension extension = node.createExtension();
        extension.name = "x-codegen-inlined";
        extension.value = Boolean.TRUE;
        node.addExtension(extension.name, extension);
    }
}

