/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.pre;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.util.LocalReferenceResolver;
import io.apicurio.datamodels.openapi.models.OasParameter;

public class OpenApiParameterInliner
extends CombinedVisitorAdapter {
    public void visitParameter(Parameter node) {
        Node referencedParameterDefNode;
        OasParameter param = (OasParameter)node;
        LocalReferenceResolver resolver = new LocalReferenceResolver();
        if (param.$ref != null && (referencedParameterDefNode = resolver.resolveRef(param.$ref, (Node)param)) != null) {
            this.inlineParameter(param, referencedParameterDefNode);
            this.markForRemoval((ExtensibleNode)referencedParameterDefNode);
        }
    }

    public void visitParameterDefinition(IDefinition node) {
        this.visitParameter((Parameter)node);
    }

    private void inlineParameter(OasParameter param, Node paramDef) {
        param.$ref = null;
        Object serializedParamDef = Library.writeNode((Node)paramDef);
        Library.readNode((Object)serializedParamDef, (Node)param);
    }

    private void markForRemoval(ExtensibleNode node) {
        Extension extension = node.createExtension();
        extension.name = "x-codegen-inlined";
        extension.value = Boolean.TRUE;
        node.addExtension(extension.name, extension);
    }
}

