/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen;

import io.apicurio.hub.api.codegen.OpenApi2JaxRs;
import io.apicurio.hub.api.codegen.beans.CodegenInfo;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class OpenApi2Thorntail
extends OpenApi2JaxRs {
    @Override
    protected void generateAll(CodegenInfo info, StringBuilder log, ZipOutputStream zipOutput) throws IOException {
        super.generateAll(info, log, zipOutput);
        if (!this.isUpdateOnly()) {
            log.append("Generating Dockerfile\r\n");
            zipOutput.putNextEntry(new ZipEntry("Dockerfile"));
            zipOutput.write(this.generateDockerfile().getBytes());
            zipOutput.closeEntry();
            log.append("Generating openshift-template.yml\r\n");
            zipOutput.putNextEntry(new ZipEntry("openshift-template.yml"));
            zipOutput.write(this.generateOpenshiftTemplate().getBytes());
            zipOutput.closeEntry();
            log.append("Generating src/main/resources/META-INF/microprofile-config.properties\r\n");
            zipOutput.putNextEntry(new ZipEntry("src/main/resources/META-INF/microprofile-config.properties"));
            zipOutput.write(this.generateMicroprofileConfigProperties().getBytes());
            zipOutput.closeEntry();
        }
    }

    private String generateDockerfile() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("Dockerfile"), (Charset)Charset.forName("UTF-8"));
        return template.replace("$ARTIFACT_ID$", this.getSettings().artifactId);
    }

    private String generateOpenshiftTemplate() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("openshift-template.yml"), (Charset)Charset.forName("UTF-8"));
        return template.replace("$ARTIFACT_ID$", this.getSettings().artifactId);
    }

    private String generateMicroprofileConfigProperties() throws IOException {
        String template = IOUtils.toString((URL)this.getResource("microprofile-config.properties"), (Charset)Charset.forName("UTF-8"));
        return template;
    }
}

