/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.properties;

import io.annot8.api.properties.MutableProperties;
import io.annot8.api.properties.Properties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MapMutableProperties
implements MutableProperties {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public MapMutableProperties() {
    }

    public MapMutableProperties(Properties properties) {
        properties.getAll().forEach(this.properties::put);
    }

    public MapMutableProperties(Map<String, Object> properties) {
        properties.forEach(this.properties::put);
    }

    public Map<String, Object> getAll() {
        return this.properties;
    }

    public void set(String key, Object value) {
        this.properties.put(key, value);
    }

    public Optional<Object> remove(String key) {
        if (this.properties.containsKey(key)) {
            return Optional.of(this.properties.remove(key));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.properties.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties p = (Properties)o;
        return Objects.equals(this.properties, p.getAll());
    }
}

