/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.factories;

import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.implementations.support.data.NotifyingItem;
import io.annot8.implementations.support.listeners.Deregister;
import io.annot8.implementations.support.listeners.Listenable;
import io.annot8.implementations.support.listeners.Listeners;
import java.util.function.Consumer;

public class NotifyingItemFactory
implements ItemFactory,
Listenable<Consumer<Item>> {
    private final Listeners<Consumer<Item>, Item> listeners = new Listeners<Consumer, Item>(Consumer::accept);
    private final ItemFactory itemFactory;

    public NotifyingItemFactory(ItemFactory itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Override
    public Deregister register(Consumer<Item> consumer) {
        return this.listeners.register(consumer);
    }

    @Override
    public void deregister(Consumer<Item> consumer) {
        this.listeners.deregister(consumer);
    }

    public Item create() {
        NotifyingItem item = new NotifyingItem(this.itemFactory.create(), this);
        this.listeners.fire(item);
        return item;
    }

    public Item create(Item parent) {
        NotifyingItem item = new NotifyingItem(this.itemFactory.create(parent), this);
        this.listeners.fire(item);
        return item;
    }

    public Item create(Consumer<Item> func) {
        NotifyingItem item = new NotifyingItem(this.itemFactory.create(func), this);
        this.listeners.fire(item);
        return item;
    }

    public Item create(Item parent, Consumer<Item> func) {
        NotifyingItem item = new NotifyingItem(this.itemFactory.create(parent, func), this);
        this.listeners.fire(item);
        return item;
    }
}

