/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.data;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.properties.MutableProperties;
import io.annot8.api.stores.GroupStore;
import io.annot8.implementations.support.factories.NotifyingItemFactory;
import java.util.Optional;
import java.util.stream.Stream;

public class NotifyingItem
implements Item {
    private final Item item;
    private final NotifyingItemFactory notifyingItemFactory;

    public NotifyingItem(Item item, NotifyingItemFactory notifyingItemFactory) {
        this.item = item;
        this.notifyingItemFactory = notifyingItemFactory;
    }

    public Item getOriginalItem() {
        return this.item;
    }

    public Optional<String> getParent() {
        return this.item.getParent();
    }

    public Optional<Content<?>> getContent(String id) {
        return this.item.getContent(id);
    }

    public Stream<Content<?>> getContents() {
        return this.item.getContents();
    }

    public <C extends Content<D>, D> Content.Builder<C, D> createContent(Class<C> clazz) {
        return this.item.createContent(clazz);
    }

    public void removeContent(String id) {
        this.item.removeContent(id);
    }

    public void discard() {
        this.item.discard();
    }

    public boolean isDiscarded() {
        return this.item.isDiscarded();
    }

    public Item createChild() {
        return this.notifyingItemFactory.create(this.item);
    }

    public GroupStore getGroups() {
        return this.item.getGroups();
    }

    public String getId() {
        return this.item.getId();
    }

    public MutableProperties getProperties() {
        return this.item.getProperties();
    }
}

