/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import airbrake.AirbrakeNotice;
import airbrake.BacktraceLine;
import java.util.Map;

public class NoticeXml {
    private final StringBuilder stringBuilder = new StringBuilder();

    public NoticeXml(AirbrakeNotice notice) {
        this.notice("2.2");
        this.apikey(notice);
        this.notifier();
        this.name("airbrake-java");
        this.version("2.2");
        this.url("https://github.com/airbrake/airbrake-java");
        this.end("notifier");
        this.error();
        this.tag("class", notice.errorClass());
        this.tag("message", NoticeXml.escapeXml(notice.errorMessage()));
        this.backtrace();
        for (String backtrace : notice.backtrace()) {
            this.line(backtrace);
        }
        this.end("backtrace");
        this.end("error");
        if (notice.hasRequest()) {
            this.addRequest(notice);
        }
        this.server_environment();
        this.tag("project-root", notice.projectRoot());
        this.tag("environment-name", notice.env());
        this.end("server-environment");
        this.end("notice");
    }

    private void addRequest(AirbrakeNotice notice) {
        this.request();
        this.tag("url", notice.url());
        this.tag("component", notice.component());
        this.vars("params", notice.request());
        this.vars("session", notice.session());
        this.vars("cgi-data", notice.environment());
        this.end("request");
    }

    private void apikey(AirbrakeNotice notice) {
        this.tag("api-key");
        this.append(notice.apiKey());
        this.end("api-key");
    }

    private void append(String str) {
        this.stringBuilder.append(str);
    }

    private void backtrace() {
        this.tag("backtrace");
    }

    private void end(String string) {
        this.append("</" + string + ">");
    }

    private void error() {
        this.tag("error");
    }

    private void line(String backtrace) {
        this.append(new BacktraceLine(backtrace).toXml());
    }

    private void name(String name) {
        this.tag("name", name);
    }

    private void notice(String string) {
        this.append("<?xml version=\"1.0\"?>");
        this.append("<notice version=\"" + string + "\">");
    }

    private void notifier() {
        this.tag("notifier");
    }

    private void request() {
        this.tag("request");
    }

    private void server_environment() {
        this.tag("server-environment");
    }

    private NoticeXml tag(String string) {
        this.append("<" + string + ">");
        return this;
    }

    private void tag(String string, String contents) {
        this.tag(string).text(contents).end(string);
    }

    private NoticeXml text(String string) {
        this.append("<![CDATA[");
        this.append(string);
        this.append("]]>");
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void url(String url) {
        this.tag("url", url);
    }

    private void vars(String sectionName, Map<String, Object> vars) {
        if (vars.isEmpty()) {
            return;
        }
        this.tag(sectionName);
        for (Map.Entry<String, Object> var : vars.entrySet()) {
            this.append("<var key=\"" + var.getKey() + "\">");
            this.text(var.getValue().toString());
            this.append("</var>");
        }
        this.end(sectionName);
    }

    private void version(String version) {
        this.tag("version", version);
    }

    protected static String escapeXml(String string) {
        if (null == string) {
            return "";
        }
        boolean anyCharactersProtected = false;
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean characterWithSpecialMeaningInXML;
            char ch = string.charAt(i);
            boolean controlCharacter = ch < ' ';
            boolean unicodeButNotAscii = ch > '~';
            boolean bl = characterWithSpecialMeaningInXML = ch == '<' || ch == '&' || ch == '>';
            if (characterWithSpecialMeaningInXML || unicodeButNotAscii || controlCharacter) {
                stringBuffer.append("&#" + ch + ";");
                anyCharactersProtected = true;
                continue;
            }
            stringBuffer.append(ch);
        }
        if (!anyCharactersProtected) {
            return string;
        }
        return stringBuffer.toString();
    }
}

