/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import airbrake.AirbrakeNotice;
import airbrake.AirbrakeNoticeBuilderUsingFilteredSystemProperties;
import airbrake.AirbrakeNotifier;
import airbrake.Backtrace;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class AirbrakeAppender
extends AppenderSkeleton {
    private final AirbrakeNotifier airbrakeNotifier = new AirbrakeNotifier();
    private String apiKey;
    private String env;
    private boolean enabled;
    private Backtrace backtrace = new Backtrace();

    public AirbrakeAppender() {
        this.setThreshold((Priority)Level.ERROR);
    }

    public AirbrakeAppender(String apiKey) {
        this.setApi_key(apiKey);
        this.setThreshold((Priority)Level.ERROR);
    }

    public AirbrakeAppender(String apiKey, Backtrace backtrace) {
        this.setApi_key(apiKey);
        this.setBacktrace(backtrace);
        this.setThreshold((Priority)Level.ERROR);
    }

    protected void append(LoggingEvent loggingEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.thereIsThrowableIn(loggingEvent)) {
            this.notifyThrowableIn(loggingEvent);
        }
    }

    public void close() {
    }

    public AirbrakeNotice newNoticeFor(Throwable throwable) {
        return new AirbrakeNoticeBuilderUsingFilteredSystemProperties(this.apiKey, this.backtrace, throwable, this.env).newNotice();
    }

    private int notifyThrowableIn(LoggingEvent loggingEvent) {
        return this.airbrakeNotifier.notify(this.newNoticeFor(this.throwable(loggingEvent)));
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setApi_key(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setBacktrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setUrl(String url) {
        this.airbrakeNotifier.setUrl(url);
    }

    private boolean thereIsThrowableIn(LoggingEvent loggingEvent) {
        return loggingEvent.getThrowableInformation() != null || loggingEvent.getMessage() instanceof Throwable;
    }

    private Throwable throwable(LoggingEvent loggingEvent) {
        ThrowableInformation throwableInfo = loggingEvent.getThrowableInformation();
        if (throwableInfo != null) {
            return throwableInfo.getThrowable();
        }
        Object message = loggingEvent.getMessage();
        if (message instanceof Throwable) {
            return (Throwable)message;
        }
        return null;
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }

    protected String getEnv() {
        return this.env;
    }
}

