/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import java.text.MessageFormat;

public class BacktraceLine {
    private final String className;
    private final String fileName;
    private final int lineNumber;
    private final String methodName;

    public BacktraceLine(String line) {
        String classAndMethodName = line.replaceAll("\\(.*", "").replaceAll("^at ", "");
        int periodSepIndex = classAndMethodName.lastIndexOf(".");
        this.className = periodSepIndex > 0 ? classAndMethodName.substring(0, classAndMethodName.lastIndexOf(".")) : classAndMethodName;
        this.fileName = this.fileName(line);
        this.lineNumber = this.lineNumber(line);
        this.methodName = this.methodName(classAndMethodName);
    }

    private String fileName(String line) {
        return line.replaceAll("^.*\\(", "").replaceAll(":.*", "");
    }

    private String methodName(String classAndMethodName) {
        return classAndMethodName.substring(classAndMethodName.lastIndexOf(".") + 1);
    }

    public BacktraceLine(String className, String fileName, int lineNumber, String methodName) {
        this.className = className;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.methodName = methodName;
    }

    String className() {
        return this.className;
    }

    String fileName() {
        return this.fileName;
    }

    int lineNumber() {
        return this.lineNumber;
    }

    private int lineNumber(String line) {
        try {
            return Integer.parseInt(line.replaceAll("^.*:", "").replaceAll("\\)", "").replaceAll(":.*", ""));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String methodName() {
        return this.methodName;
    }

    private String toBacktrace(String className, String fileName, int lineNumber, String methodName) {
        return MessageFormat.format("at {0}.{1}({2}:{3})", className, methodName, fileName, lineNumber);
    }

    public String toString() {
        return this.toBacktrace(this.className, this.fileName, this.lineNumber, this.methodName);
    }

    public String toXml() {
        return MessageFormat.format("<line method=\"{0}.{1}\" file=\"{2}\" number=\"{3}\"/>", this.className, this.methodName, this.fileName, this.lineNumber);
    }
}

