/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.res.Configuration;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.GLRendererController;
import io.agora.rtc.video.TextureRendererHelper;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class ViEAndroidGLES20
extends GLSurfaceView
implements GLSurfaceView.Renderer,
GLRendererController {
    private static String TAG = "ViEAndroidGLES20";
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private boolean surfaceCreated = false;
    private boolean openGLCreated = false;
    private boolean nativeFunctionsRegisted = false;
    private ReentrantLock nativeFunctionLock = new ReentrantLock();
    private long nativeObject = 0L;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private int nativeGLPragram = 0;
    private int[] nativeGLTextureId = new int[]{0, 0, 0};
    private int nativeOesGLPragram = 0;
    private boolean nativeGLResourceUpdated = false;
    private TextureRendererHelper textureRendererHelper = new TextureRendererHelper();
    private int mLastRotation = -1;

    public static boolean UseOpenGL2(Object object) {
        return ViEAndroidGLES20.class.isInstance(object);
    }

    public ViEAndroidGLES20(Context context) {
        this(context, false, 0, 0);
    }

    public ViEAndroidGLES20(Context context, boolean bl, int n2, int n3) {
        super(context);
        this.init(bl, n2, n3);
    }

    private void init(boolean bl, int n2, int n3) {
        if (bl) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(bl ? new ConfigChooser(8, 8, 8, 8, n2, n3) : new ConfigChooser(5, 6, 5, 0, n2, n3));
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    private static void checkEglError(String string, EGL10 eGL10) {
        int n2;
        while ((n2 = eGL10.eglGetError()) != 12288) {
            try {
                Logging.e(TAG, String.format("%s: EGL error: 0x%x", string, n2));
            }
            catch (Exception exception) {
                Log.e((String)"AGORA_SDK", (String)"egl error!!, video may not displayed!!");
            }
        }
    }

    public static boolean IsSupported(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        if (configurationInfo == null) {
            return false;
        }
        return configurationInfo.reqGlEsVersion >= 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gL10) {
        if (this.textureRendererHelper.isTextureSourceIncoming()) {
            ViEAndroidGLES20 viEAndroidGLES20 = this;
            synchronized (viEAndroidGLES20) {
                this.doDrawFrame(true);
            }
        } else {
            this.doDrawFrame(false);
        }
    }

    private void doDrawFrame(boolean bl) {
        if (bl) {
            try {
                this.textureRendererHelper.onDrawFrame(this);
            }
            catch (Exception exception) {
                Logging.e(TAG, "onDrawFrame Exception: " + exception.toString());
            }
            if (this.textureRendererHelper.useJavaRender()) {
                return;
            }
        }
        this.updateOrientation();
        this.nativeFunctionLock.lock();
        if (!this.nativeFunctionsRegisted || !this.surfaceCreated) {
            this.nativeFunctionLock.unlock();
            return;
        }
        if (!this.openGLCreated) {
            ATrace.beginSection("CreateOpenGLNative");
            if (0 != this.CreateOpenGLNative(this.nativeObject, this.viewWidth, this.viewHeight)) {
                this.nativeFunctionLock.unlock();
                return;
            }
            this.openGLCreated = true;
            ATrace.endSection();
        }
        ATrace.beginSection("DrawNative");
        if (bl) {
            TextureRendererHelper.TextureFrame textureFrame = this.textureRendererHelper.getTextureFrame();
            if (textureFrame != null) {
                this.DrawNativeTexture(this.nativeObject, textureFrame.textureType, textureFrame.texId, textureFrame.frameWidth, textureFrame.frameHeight, textureFrame.rotation, textureFrame.renderMs, textureFrame.firstRecvTimestamp, textureFrame.isDummy);
            }
        } else {
            this.DrawNative(this.nativeObject);
        }
        ATrace.endSection();
        this.nativeFunctionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        this.surfaceCreated = true;
        this.viewWidth = n2;
        this.viewHeight = n3;
        ViEAndroidGLES20 viEAndroidGLES20 = this;
        synchronized (viEAndroidGLES20) {
            this.textureRendererHelper.onSurfaceChanged(this, n2, n3);
            if (this.textureRendererHelper.useJavaRender()) {
                return;
            }
        }
        Logging.i("AGORA_SDK", "Surface changed to width " + n2 + " height " + n3);
        this.nativeFunctionLock.lock();
        try {
            if (this.nativeFunctionsRegisted && this.CreateOpenGLNative(this.nativeObject, n2, n3) == 0) {
                this.openGLCreated = true;
            }
        }
        catch (Exception exception) {
            Log.w((String)"AGORA_SDK", (String)"Exception occurs when create RtcEngine");
        }
        finally {
            this.nativeFunctionLock.unlock();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.updateOrientation();
    }

    private int checkOrientation() {
        Display display;
        if (this.getContext() != null && this.getContext().getSystemService("window") != null && (display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                int n2 = display.getRotation();
                return n2;
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }

    private void updateOrientation() {
        int n2 = this.checkOrientation();
        if (n2 != this.mLastRotation) {
            this.nativeFunctionLock.lock();
            if (this.nativeFunctionsRegisted) {
                this.OnCfgChangedNative(this.nativeObject, n2);
            }
            this.mLastRotation = n2;
            this.nativeFunctionLock.unlock();
        }
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
    }

    public void RegisterNativeObject(long l2) {
        this.nativeFunctionLock.lock();
        this.nativeObject = l2;
        this.nativeFunctionsRegisted = true;
        this.nativeFunctionLock.unlock();
    }

    public void DeRegisterNativeObject() {
        this.nativeFunctionLock.lock();
        this.nativeFunctionsRegisted = false;
        this.openGLCreated = false;
        this.nativeObject = 0L;
        this.nativeFunctionLock.unlock();
        this.releaseOpenGLResource();
    }

    @Override
    public void ReDraw() {
        if (this.surfaceCreated) {
            this.requestRender();
        }
    }

    @Override
    public int GetAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    public void UpdateOpenGLResource(int[] nArray) {
        this.nativeGLPragram = nArray[0];
        for (int i2 = 0; i2 < 3; ++i2) {
            this.nativeGLTextureId[i2] = nArray[i2 + 1];
        }
        this.nativeOesGLPragram = nArray[4];
        this.nativeGLResourceUpdated = true;
        Logging.i(TAG, "UpdateOpenGLResource, program = " + nArray[0] + " texture[0~2] = " + nArray[1] + " ," + nArray[2] + " ," + nArray[3]);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ViEAndroidGLES20 viEAndroidGLES20 = ViEAndroidGLES20.this;
                synchronized (viEAndroidGLES20) {
                    ViEAndroidGLES20.this.surfaceCreated = false;
                    ViEAndroidGLES20.this.textureRendererHelper.releaseSurfaceTexture();
                }
            }
        });
        super.surfaceDestroyed(surfaceHolder);
    }

    public void releaseOpenGLResource() {
        if (!this.nativeGLResourceUpdated) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                int n2;
                Logging.i(TAG, "releaseOpenGLResource, value = " + ViEAndroidGLES20.this.nativeGLPragram + " ," + ViEAndroidGLES20.this.nativeGLTextureId[0] + " ," + ViEAndroidGLES20.this.nativeGLTextureId[1] + " ," + ViEAndroidGLES20.this.nativeGLTextureId[2] + ", " + ViEAndroidGLES20.this.nativeOesGLPragram);
                if (ViEAndroidGLES20.this.nativeGLPragram > 0) {
                    GLES20.glDeleteProgram((int)ViEAndroidGLES20.this.nativeGLPragram);
                }
                if (ViEAndroidGLES20.this.nativeGLTextureId[0] > 0) {
                    GLES20.glDeleteTextures((int)3, (int[])ViEAndroidGLES20.this.nativeGLTextureId, (int)0);
                }
                if (ViEAndroidGLES20.this.nativeOesGLPragram > 0) {
                    GLES20.glDeleteProgram((int)ViEAndroidGLES20.this.nativeOesGLPragram);
                }
                if ((n2 = GLES20.glGetError()) != 0) {
                    Logging.e(TAG, "glDelete error: " + n2);
                }
            }
        });
        this.nativeGLResourceUpdated = false;
    }

    public void reDrawNativeI420() {
        this.textureRendererHelper.setTextureSourceIncoming(false);
        this.ReDraw();
    }

    public void reDrawJavaI420(VideoFrame.I420Buffer i420Buffer, int n2, long l2) {
        this.textureRendererHelper.setTextureSourceIncoming(false);
        AgoraVideoDebugger.onI420Buffer(i420Buffer, n2, l2);
        this.ReDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverVideoTextureFrame(VideoFrame.TextureBuffer textureBuffer, int n2, long l2, long l3, boolean bl) {
        this.textureRendererHelper.setTextureSourceIncoming(true);
        ViEAndroidGLES20 viEAndroidGLES20 = this;
        synchronized (viEAndroidGLES20) {
            this.textureRendererHelper.onTextureFrameArrived(textureBuffer, n2, l2, l3, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textureRenderThreadWillExit() {
        ViEAndroidGLES20 viEAndroidGLES20 = this;
        synchronized (viEAndroidGLES20) {
            Logging.i(TAG, "texture render thread will exit");
            this.textureRendererHelper.releaseProducerResourceIfNotYet();
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.textureRendererHelper.isTextureSourceIncoming()) {
            this.textureRendererHelper.onFrameAvailable(this);
        }
    }

    private native int CreateOpenGLNative(long var1, int var3, int var4);

    private native void DrawNative(long var1);

    private native void OnCfgChangedNative(long var1, int var3);

    private native void DrawNativeTexture(long var1, int var3, int var4, int var5, int var6, int var7, long var8, long var10, boolean var12);

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            this.mRedSize = n2;
            this.mGreenSize = n3;
            this.mBlueSize = n4;
            this.mAlphaSize = n5;
            this.mDepthSize = n6;
            this.mStencilSize = n7;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, null, 0, nArray);
            int n2 = nArray[0];
            if (n2 <= 0) {
                Logging.w(TAG, "no configurations found");
                return null;
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n2];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, eGLConfigArray, n2, nArray);
            return this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n2 < this.mDepthSize || n3 < this.mStencilSize) continue;
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n4 != this.mRedSize || n5 != this.mGreenSize || n6 != this.mBlueSize || n7 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, this.mValue)) {
                return this.mValue[0];
            }
            return n3;
        }

        private void printConfigs(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            int n2 = eGLConfigArray.length;
            Logging.w(TAG, String.format("%d configurations", n2));
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.w(TAG, String.format("Configuration %d:\n", i2));
                this.printConfig(eGL10, eGLDisplay, eGLConfigArray[i2]);
            }
        }

        private void printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] stringArray = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] nArray2 = new int[1];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                String string = stringArray[i2];
                if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, nArray2)) {
                    Logging.w(TAG, String.format("  %s: %d\n", string, nArray2[0]));
                    continue;
                }
                while (eGL10.eglGetError() != 12288) {
                }
            }
        }
    }
}

