/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.spatialaudio.internal;

import io.agora.rtc.spatialaudio.ILocalSpatialAudioEngine;
import io.agora.rtc.spatialaudio.LocalSpatialAudioConfig;
import io.agora.rtc.spatialaudio.RemoteVoicePositionInfo;
import java.util.Locale;

public class LocalSpatialAudioImpl
extends ILocalSpatialAudioEngine {
    private static final String TAG = LocalSpatialAudioImpl.class.getSimpleName();
    private long mNativeHandle = 0L;

    @Override
    public int initialize(LocalSpatialAudioConfig localSpatialAudioConfig) {
        if (localSpatialAudioConfig.mRtcEngine == null) {
            return -2;
        }
        this.mNativeHandle = this.nativeObjectInit(localSpatialAudioConfig, localSpatialAudioConfig.mRtcEngine.getNativeHandle());
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return 0;
    }

    @Override
    protected int release() {
        if (this.mNativeHandle != 0L) {
            LocalSpatialAudioImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        return 0;
    }

    @Override
    public int setMaxAudioRecvCount(int n2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.max_hear_count\":%d}", n2));
    }

    @Override
    public int setAudioRecvRange(float f2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.hear_range\":%f}", Float.valueOf(f2)));
    }

    @Override
    public int setDistanceUnit(float f2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.distance_unit\":%f}", Float.valueOf(f2)));
    }

    @Override
    public int updateSelfPosition(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (fArray.length != 3 || fArray2.length != 3 || fArray3.length != 3 || fArray4.length != 3) {
            return -2;
        }
        return this.nativeUpdateSelfPosition(this.mNativeHandle, fArray, fArray2, fArray3, fArray4);
    }

    @Override
    public int muteLocalAudioStream(boolean bl) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.mute_local_stream\":%s}", bl ? "true" : "false"));
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean bl) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.mute_all_remote_audio_streams\":%s}", bl ? "true" : "false"));
    }

    @Override
    public int updateRemotePosition(int n2, RemoteVoicePositionInfo remoteVoicePositionInfo) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (remoteVoicePositionInfo == null || remoteVoicePositionInfo.position == null || remoteVoicePositionInfo.position.length != 3) {
            return -2;
        }
        if (remoteVoicePositionInfo.forward == null) {
            remoteVoicePositionInfo.forward = new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.nativeUpdateRemotePosition(this.mNativeHandle, n2, remoteVoicePositionInfo.position, remoteVoicePositionInfo.forward);
    }

    @Override
    public int removeRemotePosition(int n2) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveRemotePosition(this.mNativeHandle, n2);
    }

    @Override
    public int clearRemotePositions() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeClearRemotePositions(this.mNativeHandle);
    }

    private native long nativeObjectInit(Object var1, long var2);

    private static native int nativeDestroy(long var0);

    private native int nativeSetParameters(long var1, String var3);

    private native int nativeUpdateSelfPosition(long var1, float[] var3, float[] var4, float[] var5, float[] var6);

    private native int nativeUpdateRemotePosition(long var1, int var3, float[] var4, float[] var5);

    private native int nativeRemoveRemotePosition(long var1, int var3);

    private native int nativeClearRemotePositions(long var1);
}

