/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.stream;

import io.activej.codegen.util.WithInitializer;
import io.activej.serializer.BinaryOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamOutput
implements Closeable,
WithInitializer<StreamOutput> {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private BinaryOutput out;
    private final OutputStream outputStream;

    private StreamOutput(OutputStream outputStream, int initialBufferSize) {
        this.outputStream = outputStream;
        this.out = new BinaryOutput(this.allocate(initialBufferSize));
    }

    public static StreamOutput create(OutputStream output) {
        return new StreamOutput(output, 16384);
    }

    public static StreamOutput create(OutputStream outputStream, int bufferSize) {
        return new StreamOutput(outputStream, bufferSize);
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.outputStream.close();
        this.recycle(this.out.array());
        this.out = null;
    }

    public BinaryOutput out() {
        return this.out;
    }

    public void out(BinaryOutput out) {
        this.out = out;
    }

    public byte[] array() {
        return this.out.array();
    }

    public int pos() {
        return this.out.pos();
    }

    public void pos(int pos) {
        this.out.pos(pos);
    }

    public int limit() {
        return this.out.array().length;
    }

    public int remaining() {
        return this.limit() - this.pos();
    }

    public void ensure(int bytes) throws IOException {
        if (this.remaining() < bytes) {
            this.doEnsureSize(bytes);
        }
    }

    private void doEnsureSize(int size) throws IOException {
        this.doFlush();
        if (this.remaining() < size) {
            this.recycle(this.out.array());
            this.out = new BinaryOutput(this.allocate(size));
        }
    }

    protected byte[] allocate(int size) {
        return new byte[size];
    }

    protected void recycle(byte[] array) {
    }

    public final void flush() throws IOException {
        this.doFlush();
        this.outputStream.flush();
    }

    private void doFlush() throws IOException {
        if (this.out.pos() > 0) {
            this.outputStream.write(this.out.array(), 0, this.out.pos());
            this.out.pos(0);
        }
    }

    public final void write(byte[] b) throws IOException {
        this.ensure(b.length);
        this.out.write(b);
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        this.out.write(b, off, len);
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.ensure(1);
        this.out.writeBoolean(v);
    }

    public final void writeByte(byte v) throws IOException {
        if (this.out.pos() < this.out.array().length) {
            this.out.writeByte(v);
        } else {
            this.writeByteImpl(v);
        }
    }

    private void writeByteImpl(byte v) throws IOException {
        this.doEnsureSize(1);
        this.out.writeByte(v);
    }

    public final void writeShort(short v) throws IOException {
        this.ensure(2);
        this.out.writeShort(v);
    }

    public final void writeInt(int v) throws IOException {
        this.ensure(4);
        this.out.writeInt(v);
    }

    public final void writeLong(long v) throws IOException {
        this.ensure(8);
        this.out.writeLong(v);
    }

    public final void writeVarInt(int v) throws IOException {
        this.ensure(5);
        this.out.writeVarInt(v);
    }

    public final void writeVarLong(long v) throws IOException {
        this.ensure(9);
        this.out.writeVarLong(v);
    }

    public final void writeFloat(float v) throws IOException {
        this.ensure(4);
        this.out.writeFloat(v);
    }

    public final void writeDouble(double v) throws IOException {
        this.ensure(8);
        this.out.writeDouble(v);
    }

    public final void writeChar(char v) throws IOException {
        this.ensure(2);
        this.out.writeChar(v);
    }

    public final void writeString(@NotNull String s) throws IOException {
        this.writeUTF8(s);
    }

    public final void writeUTF8(@NotNull String s) throws IOException {
        this.ensure(5 + s.length() * 3);
        this.out.writeUTF8(s);
    }

    public final void writeIso88591(@NotNull String s) throws IOException {
        this.ensure(5 + s.length() * 3);
        this.out.writeIso88591(s);
    }

    public final void writeUTF16(@NotNull String s) throws IOException {
        this.ensure(5 + s.length() * 2);
        this.out.writeUTF16(s);
    }

    public final void writeUTF8Nullable(@Nullable String s) throws IOException {
        this.ensure(s != null ? 5 + s.length() * 3 : 1);
        this.out.writeUTF8Nullable(s);
    }

    public final void writeIso88591Nullable(@Nullable String s) throws IOException {
        this.ensure(s != null ? 5 + s.length() * 3 : 6);
        this.out.writeIso88591Nullable(s);
    }

    public final void writeUTF16Nullable(@Nullable String s) throws IOException {
        this.ensure(s != null ? 5 + s.length() * 2 : 6);
        this.out.writeUTF16Nullable(s);
    }
}

