/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.StringFormat;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.util.BinaryOutputUtils;
import io.activej.serializer.util.Utils;

public final class SerializerDefString
extends AbstractSerializerDef
implements SerializerDefWithNullable {
    private final StringFormat format;
    private final boolean nullable;

    private SerializerDefString(StringFormat format, boolean nullable) {
        this.format = format;
        this.nullable = nullable;
    }

    public SerializerDefString() {
        this(StringFormat.UTF8, false);
    }

    public SerializerDefString(StringFormat format) {
        this(format, false);
    }

    @Override
    public SerializerDefString ensureNullable(CompatibilityLevel compatibilityLevel) {
        return new SerializerDefString(this.format, true);
    }

    public SerializerDefString encoding(StringFormat format) {
        return new SerializerDefString(format, this.nullable);
    }

    @Override
    public Class<?> getEncodeType() {
        return String.class;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.set((StoreDef)pos, (Expression)Utils.get(() -> {
            Expression string = Expressions.cast((Expression)value, String.class);
            if (compatibilityLevel == CompatibilityLevel.LEVEL_1 && (this.format == StringFormat.ISO_8859_1 || this.format == StringFormat.UTF8)) {
                return this.nullable ? Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8mb3Nullable", (Expression[])new Expression[]{buf, pos, string}) : Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8mb3", (Expression[])new Expression[]{buf, pos, string});
            }
            switch (this.format) {
                case ISO_8859_1: {
                    return this.nullable ? Expressions.staticCall(BinaryOutputUtils.class, (String)"writeIso88591Nullable", (Expression[])new Expression[]{buf, pos, string}) : Expressions.staticCall(BinaryOutputUtils.class, (String)"writeIso88591", (Expression[])new Expression[]{buf, pos, string});
                }
                case UTF8: {
                    return this.nullable ? Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8Nullable", (Expression[])new Expression[]{buf, pos, string}) : Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8", (Expression[])new Expression[]{buf, pos, string});
                }
                case UTF16: {
                    String LE = compatibilityLevel.isLittleEndian() ? "LE" : "";
                    return this.nullable ? Expressions.staticCall(BinaryOutputUtils.class, (String)("writeUTF16Nullable" + LE), (Expression[])new Expression[]{buf, pos, string}) : Expressions.staticCall(BinaryOutputUtils.class, (String)("writeUTF16" + LE), (Expression[])new Expression[]{buf, pos, string});
                }
                case UTF8_MB3: {
                    return this.nullable ? Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8mb3Nullable", (Expression[])new Expression[]{buf, pos, string}) : Expressions.staticCall(BinaryOutputUtils.class, (String)"writeUTF8mb3", (Expression[])new Expression[]{buf, pos, string});
                }
            }
            throw new AssertionError();
        }));
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel == CompatibilityLevel.LEVEL_1 && (this.format == StringFormat.ISO_8859_1 || this.format == StringFormat.UTF8)) {
            return this.nullable ? Expressions.call((Expression)in, (String)"readUTF8mb3Nullable", (Expression[])new Expression[0]) : Expressions.call((Expression)in, (String)"readUTF8mb3", (Expression[])new Expression[0]);
        }
        switch (this.format) {
            case ISO_8859_1: {
                return this.nullable ? Expressions.call((Expression)in, (String)"readIso88591Nullable", (Expression[])new Expression[0]) : Expressions.call((Expression)in, (String)"readIso88591", (Expression[])new Expression[0]);
            }
            case UTF8: {
                return this.nullable ? Expressions.call((Expression)in, (String)"readUTF8Nullable", (Expression[])new Expression[0]) : Expressions.call((Expression)in, (String)"readUTF8", (Expression[])new Expression[0]);
            }
            case UTF16: {
                String LE = compatibilityLevel.isLittleEndian() ? "LE" : "";
                return this.nullable ? Expressions.call((Expression)in, (String)("readUTF16Nullable" + LE), (Expression[])new Expression[0]) : Expressions.call((Expression)in, (String)("readUTF16" + LE), (Expression[])new Expression[0]);
            }
            case UTF8_MB3: {
                return this.nullable ? Expressions.call((Expression)in, (String)"readUTF8mb3Nullable", (Expression[])new Expression[0]) : Expressions.call((Expression)in, (String)"readUTF8mb3", (Expression[])new Expression[0]);
            }
        }
        throw new AssertionError();
    }
}

