/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefPrimitive;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;

public final class SerializerDefBoolean
extends SerializerDefPrimitive
implements SerializerDefWithNullable {
    public static final byte NULLABLE_NULL = 0;
    public static final byte NULLABLE_FALSE = 2;
    public static final byte NULLABLE_TRUE = 3;
    private final boolean nullable;

    public SerializerDefBoolean() {
        this(true);
    }

    public SerializerDefBoolean(boolean wrapped) {
        this(wrapped, false);
    }

    public SerializerDefBoolean(boolean wrapped, boolean nullable) {
        super(Boolean.TYPE, wrapped);
        if (nullable && !wrapped) {
            throw new IllegalArgumentException("Primitive cannot be nullable");
        }
        this.nullable = nullable;
    }

    @Override
    public SerializerDef ensureWrapped() {
        return new SerializerDefBoolean(true, this.nullable);
    }

    @Override
    protected boolean castToPrimitive() {
        return !this.nullable;
    }

    @Override
    protected Expression doSerialize(Expression byteArray, Variable off, Expression value, CompatibilityLevel compatibilityLevel) {
        return !this.nullable ? SerializerExpressions.writeByte(byteArray, off, value) : Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(byteArray, off, Expressions.value((Object)0)), (Expression)SerializerExpressions.writeByte(byteArray, off, Expressions.bitOr((Expression)Expressions.cast((Expression)Expressions.call((Expression)value, (String)"booleanValue", (Expression[])new Expression[0]), Byte.TYPE), (Expression)Expressions.value((Object)2))));
    }

    @Override
    protected Expression doDeserialize(Expression in, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)SerializerExpressions.readByte(in), aByte -> !this.nullable ? Expressions.cast((Expression)aByte, Boolean.TYPE) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)aByte, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(Boolean.class), (Expression)Expressions.cast((Expression)Expressions.bitAnd((Expression)aByte, (Expression)Expressions.value((Object)1)), Boolean.class)));
    }

    @Override
    public SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_4.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return new SerializerDefBoolean(this.wrapped, true);
    }
}

