/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.annotations;

import io.activej.serializer.SerializerDef;
import io.activej.serializer.StringFormat;
import io.activej.serializer.annotations.SerializeClass;
import io.activej.serializer.annotations.SerializeFixedSize;
import io.activej.serializer.annotations.SerializeNullable;
import io.activej.serializer.annotations.SerializeReference;
import io.activej.serializer.annotations.SerializeStringFormat;
import io.activej.serializer.annotations.SerializeVarLength;
import java.lang.annotation.Annotation;

public final class CustomAnnotations {
    public static SerializeNullable serializeNullable() {
        return new SerializerNullableImpl();
    }

    public static SerializeClass serializeClass(Class<? extends SerializerDef> value) {
        return new SerializeClassImpl(value);
    }

    public static SerializeClass serializeClass(Class<?>[] subclasses, String subclassesId, int subclassesIdx) {
        return new SerializeClassImpl(subclasses, subclassesId, subclassesIdx);
    }

    public static SerializeFixedSize serializeFixedSize(int value) {
        return new SerializeFixedSizeImpl(value);
    }

    public static SerializeReference serializeReference() {
        return new SerializerReferenceImpl();
    }

    public static SerializeStringFormat serializeStringFormat(StringFormat stringFormat) {
        return new SerializerStringFormatImpl(stringFormat);
    }

    public static SerializeVarLength serializeVarLength() {
        return new SerializerVarLengthImpl();
    }

    static final class SerializerNullableImpl
    extends AbstractSerializeAnnotation
    implements SerializeNullable {
        SerializerNullableImpl() {
        }
    }

    static final class SerializeClassImpl
    extends AbstractSerializeAnnotation
    implements SerializeClass {
        final Class<? extends SerializerDef> value;
        final Class<?>[] subclasses;
        final String subclassesId;
        final int subclassesIdx;

        SerializeClassImpl(Class<? extends SerializerDef> value) {
            this.value = value;
            this.subclasses = new Class[0];
            this.subclassesId = "";
            this.subclassesIdx = 0;
        }

        SerializeClassImpl(Class<?>[] subclasses, String subclassesId, int subclassesIdx) {
            this.value = SerializerDef.class;
            this.subclasses = subclasses;
            this.subclassesId = subclassesId;
            this.subclassesIdx = subclassesIdx;
        }

        @Override
        public Class<? extends SerializerDef> value() {
            return this.value;
        }

        @Override
        public Class<?>[] subclasses() {
            return this.subclasses;
        }

        @Override
        public String subclassesId() {
            return this.subclassesId;
        }

        @Override
        public int subclassesIdx() {
            return this.subclassesIdx;
        }
    }

    static final class SerializeFixedSizeImpl
    extends AbstractSerializeAnnotation
    implements SerializeFixedSize {
        final int value;

        SerializeFixedSizeImpl(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    static final class SerializerReferenceImpl
    extends AbstractSerializeAnnotation
    implements SerializeReference {
        SerializerReferenceImpl() {
        }
    }

    static final class SerializerStringFormatImpl
    extends AbstractSerializeAnnotation
    implements SerializeStringFormat {
        final StringFormat stringFormat;

        SerializerStringFormatImpl(StringFormat format) {
            this.stringFormat = format;
        }

        @Override
        public StringFormat value() {
            return this.stringFormat;
        }
    }

    static final class SerializerVarLengthImpl
    extends AbstractSerializeAnnotation
    implements SerializeVarLength {
        SerializerVarLengthImpl() {
        }
    }

    static abstract class AbstractSerializeAnnotation
    implements Annotation {
        AbstractSerializeAnnotation() {
        }

        @Override
        public final Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException();
        }

        public final int[] path() {
            return new int[0];
        }
    }
}

