/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.ClassKey;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.WithInitializer;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.BinaryInput;
import io.activej.serializer.BinaryOutput;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.CorruptedDataException;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.StringFormat;
import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeClass;
import io.activej.serializer.annotations.SerializeClasses;
import io.activej.serializer.annotations.SerializeFixedSize;
import io.activej.serializer.annotations.SerializeFixedSizes;
import io.activej.serializer.annotations.SerializeNullable;
import io.activej.serializer.annotations.SerializeNullables;
import io.activej.serializer.annotations.SerializeProfiles;
import io.activej.serializer.annotations.SerializeReference;
import io.activej.serializer.annotations.SerializeReferences;
import io.activej.serializer.annotations.SerializeStringFormat;
import io.activej.serializer.annotations.SerializeStringFormats;
import io.activej.serializer.annotations.SerializeVarLength;
import io.activej.serializer.annotations.SerializeVarLengths;
import io.activej.serializer.impl.ForwardingSerializerDef;
import io.activej.serializer.impl.SerializerDefArray;
import io.activej.serializer.impl.SerializerDefBoolean;
import io.activej.serializer.impl.SerializerDefByte;
import io.activej.serializer.impl.SerializerDefChar;
import io.activej.serializer.impl.SerializerDefClass;
import io.activej.serializer.impl.SerializerDefDouble;
import io.activej.serializer.impl.SerializerDefEnum;
import io.activej.serializer.impl.SerializerDefEnumMap;
import io.activej.serializer.impl.SerializerDefEnumSet;
import io.activej.serializer.impl.SerializerDefFloat;
import io.activej.serializer.impl.SerializerDefHashMap;
import io.activej.serializer.impl.SerializerDefHashSet;
import io.activej.serializer.impl.SerializerDefInet4Address;
import io.activej.serializer.impl.SerializerDefInet6Address;
import io.activej.serializer.impl.SerializerDefInt;
import io.activej.serializer.impl.SerializerDefLinkedList;
import io.activej.serializer.impl.SerializerDefList;
import io.activej.serializer.impl.SerializerDefLong;
import io.activej.serializer.impl.SerializerDefMap;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefReference;
import io.activej.serializer.impl.SerializerDefRegularCollection;
import io.activej.serializer.impl.SerializerDefSet;
import io.activej.serializer.impl.SerializerDefShort;
import io.activej.serializer.impl.SerializerDefString;
import io.activej.serializer.impl.SerializerDefSubclass;
import io.activej.serializer.impl.SerializerDefWithFixedSize;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerDefWithVarLength;
import io.activej.serializer.impl.SerializerExpressions;
import io.activej.serializer.util.Utils;
import io.activej.types.AnnotatedTypes;
import io.activej.types.AnnotationUtils;
import io.activej.types.TypeT;
import io.activej.types.scanner.TypeScannerRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class SerializerBuilder
implements WithInitializer<SerializerBuilder> {
    private final DefiningClassLoader classLoader;
    private final TypeScannerRegistry<SerializerDef> registry = TypeScannerRegistry.create();
    private Class<?> implementationClass = Object.class;
    private String profile;
    private int encodeVersionMax = Integer.MAX_VALUE;
    private int decodeVersionMin = 0;
    private int decodeVersionMax = Integer.MAX_VALUE;
    private CompatibilityLevel compatibilityLevel = CompatibilityLevel.LEVEL_4;
    private int autoOrderingStart = 1;
    private int autoOrderingStride = 1;
    private boolean annotationsCompatibilityMode;
    private final Map<Object, List<Class<?>>> extraSubclassesMap = new HashMap();
    private final Map<Class<? extends Annotation>, Map<Class<? extends Annotation>, Function<? extends Annotation, ? extends Annotation>>> annotationAliases = new HashMap<Class<? extends Annotation>, Map<Class<? extends Annotation>, Function<? extends Annotation, ? extends Annotation>>>();
    private static final Map<Class<? extends Annotation>, Function<Annotation, ? extends Annotation[]>> REPEATABLES_VALUE = new HashMap<Class<? extends Annotation>, Function<Annotation, ? extends Annotation[]>>();
    private static final Map<Class<? extends Annotation>, Function<Annotation, int[]>> ANNOTATIONS_PATH = new HashMap<Class<? extends Annotation>, Function<Annotation, int[]>>();

    private SerializerBuilder(DefiningClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static SerializerBuilder create() {
        return SerializerBuilder.create(DefiningClassLoader.create());
    }

    public static SerializerBuilder create(DefiningClassLoader definingClassLoader) {
        SerializerBuilder builder = new SerializerBuilder(definingClassLoader);
        builder.with(Boolean.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefBoolean(false))).with(Character.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefChar(false))).with(Byte.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefByte(false))).with(Short.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefShort(false))).with(Integer.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefInt(false))).with(Long.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefLong(false))).with(Float.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefFloat(false))).with(Double.TYPE, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefDouble(false))).with((Type)((Object)Boolean.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefBoolean(true))).with((Type)((Object)Character.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefChar(true))).with((Type)((Object)Byte.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefByte(true))).with((Type)((Object)Short.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefShort(true))).with((Type)((Object)Integer.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefInt(true))).with((Type)((Object)Long.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefLong(true))).with((Type)((Object)Float.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefFloat(true))).with((Type)((Object)Double.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefDouble(true)));
        for (Type type : new Type[]{boolean[].class, char[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, Object[].class}) {
            builder.with(type, (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefArray((SerializerDef)ctx.scanTypeArgument(0), ctx.getRawType())));
        }
        LinkedHashMap<Class, AbstractSerializerDef> addressMap = new LinkedHashMap<Class, AbstractSerializerDef>();
        addressMap.put(Inet4Address.class, new SerializerDefInet4Address());
        addressMap.put(Inet6Address.class, new SerializerDefInet6Address());
        builder.with((Type)((Object)Inet4Address.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefInet4Address())).with((Type)((Object)Inet6Address.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefInet6Address())).with((Type)((Object)InetAddress.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefSubclass(InetAddress.class, addressMap, 0)));
        builder.with((Type)((Object)Enum.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> {
            for (Method method : ctx.getRawType().getDeclaredMethods()) {
                if (!AnnotationUtils.hasAnnotation(Serialize.class, (Annotation[])method.getAnnotations())) continue;
                return builder.scan((TypeScannerRegistry.Context<SerializerDef>)ctx);
            }
            for (AccessibleObject accessibleObject : ctx.getRawType().getDeclaredFields()) {
                if (!AnnotationUtils.hasAnnotation(Serialize.class, (Annotation[])accessibleObject.getAnnotations())) continue;
                return builder.scan((TypeScannerRegistry.Context<SerializerDef>)ctx);
            }
            return new SerializerDefEnum(ctx.getRawType());
        })).with((Type)((Object)String.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> {
            SerializeStringFormat a = builder.getAnnotation(SerializeStringFormat.class, ctx.getAnnotations());
            return new SerializerDefString(a == null ? StringFormat.UTF8 : a.value());
        })).with((Type)((Object)Collection.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefRegularCollection((SerializerDef)ctx.scanTypeArgument(0), Collection.class, ArrayList.class))).with((Type)((Object)Queue.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefRegularCollection((SerializerDef)ctx.scanTypeArgument(0), Queue.class, ArrayDeque.class))).with((Type)((Object)List.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefList((SerializerDef)ctx.scanTypeArgument(0)))).with((Type)((Object)ArrayList.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefRegularCollection((SerializerDef)ctx.scanTypeArgument(0), ArrayList.class, ArrayList.class))).with((Type)((Object)LinkedList.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefLinkedList((SerializerDef)ctx.scanTypeArgument(0)))).with((Type)((Object)Map.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefMap((SerializerDef)ctx.scanTypeArgument(0), (SerializerDef)ctx.scanTypeArgument(1)))).with((Type)((Object)HashMap.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefHashMap((SerializerDef)ctx.scanTypeArgument(0), (SerializerDef)ctx.scanTypeArgument(1), HashMap.class, HashMap.class))).with((Type)((Object)LinkedHashMap.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefHashMap((SerializerDef)ctx.scanTypeArgument(0), (SerializerDef)ctx.scanTypeArgument(1), LinkedHashMap.class, LinkedHashMap.class))).with((Type)((Object)EnumMap.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefEnumMap((SerializerDef)ctx.scanTypeArgument(0), (SerializerDef)ctx.scanTypeArgument(1)))).with((Type)((Object)Set.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefSet((SerializerDef)ctx.scanTypeArgument(0)))).with((Type)((Object)HashSet.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefHashSet((SerializerDef)ctx.scanTypeArgument(0), HashSet.class, HashSet.class))).with((Type)((Object)LinkedHashSet.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefHashSet((SerializerDef)ctx.scanTypeArgument(0), LinkedHashSet.class, LinkedHashSet.class))).with((Type)((Object)EnumSet.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)ctx -> new SerializerDefEnumSet((SerializerDef)ctx.scanTypeArgument(0)))).with((Type)((Object)Object.class), (TypeScannerRegistry.Mapping<SerializerDef>)((TypeScannerRegistry.Mapping)builder::scan));
        return builder;
    }

    public SerializerBuilder with(TypeT<?> typeT, TypeScannerRegistry.Mapping<SerializerDef> fn) {
        return this.with(typeT.getType(), fn);
    }

    public SerializerBuilder with(Type type, TypeScannerRegistry.Mapping<SerializerDef> fn) {
        this.registry.with(type, ctx -> {
            SerializeFixedSize annotationFixedSize;
            LinkedHashMap map;
            SerializerDef serializerDef;
            Class rawClass = ctx.getRawType();
            SerializeClass annotationClass = this.getAnnotation(SerializeClass.class, ctx.getAnnotations());
            if (annotationClass != null || (annotationClass = this.getAnnotation(SerializeClass.class, rawClass.getAnnotations())) != null) {
                if (annotationClass.value() != SerializerDef.class) {
                    try {
                        serializerDef = annotationClass.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    map = new LinkedHashMap();
                    LinkedHashSet subclassesSet = new LinkedHashSet(Arrays.asList(annotationClass.subclasses()));
                    subclassesSet.addAll(this.extraSubclassesMap.getOrDefault(rawClass, Collections.emptyList()));
                    subclassesSet.addAll(this.extraSubclassesMap.getOrDefault(annotationClass.subclassesId(), Collections.emptyList()));
                    for (Class clazz : subclassesSet) {
                        map.put(clazz, (SerializerDef)ctx.scan((Type)clazz));
                    }
                    serializerDef = new SerializerDefSubclass(rawClass, map, annotationClass.subclassesIdx());
                }
            } else if (this.extraSubclassesMap.containsKey(rawClass)) {
                map = new LinkedHashMap();
                for (Class<?> subclass : this.extraSubclassesMap.get(rawClass)) {
                    map.put(subclass, (SerializerDef)ctx.scan(subclass));
                }
                serializerDef = new SerializerDefSubclass(rawClass, map, 0);
            } else {
                serializerDef = (SerializerDef)fn.apply(ctx);
            }
            if (this.hasAnnotation(SerializeReference.class, ctx.getAnnotations()) || this.hasAnnotation(SerializeReference.class, rawClass.getAnnotations())) {
                serializerDef = new SerializerDefReference(serializerDef);
            }
            if (this.hasAnnotation(SerializeVarLength.class, ctx.getAnnotations())) {
                serializerDef = ((SerializerDefWithVarLength)serializerDef).ensureVarLength();
            }
            if ((annotationFixedSize = this.getAnnotation(SerializeFixedSize.class, ctx.getAnnotations())) != null) {
                serializerDef = ((SerializerDefWithFixedSize)serializerDef).ensureFixedSize(annotationFixedSize.value());
            }
            if (this.hasAnnotation(SerializeNullable.class, ctx.getAnnotations())) {
                serializerDef = serializerDef instanceof SerializerDefWithNullable ? ((SerializerDefWithNullable)serializerDef).ensureNullable(this.compatibilityLevel) : new SerializerDefNullable(serializerDef);
            }
            return serializerDef;
        });
        return this;
    }

    @Nullable
    private <A extends Annotation> A getAnnotation(Class<A> type, Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (annotation.annotationType() != type) continue;
            return (A)annotation;
        }
        Map<Class<? extends Annotation>, Function<? extends Annotation, ? extends Annotation>> aliasesMap = this.annotationAliases.get(type);
        if (aliasesMap != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation annotation = annotations[i];
                Function<? extends Annotation, ? extends Annotation> mapping = aliasesMap.get(annotation.annotationType());
                if (mapping == null) continue;
                return (A)mapping.apply(annotation);
            }
        }
        return null;
    }

    private <A extends Annotation> boolean hasAnnotation(Class<A> type, Annotation[] annotations) {
        Map aliasesMap = this.annotationAliases.getOrDefault(type, Collections.emptyMap());
        for (int i = 0; i < annotations.length; ++i) {
            Class<? extends Annotation> annotationType = annotations[i].annotationType();
            if (annotationType != type && !aliasesMap.containsKey(annotationType)) continue;
            return true;
        }
        return false;
    }

    public SerializerBuilder withImplementationClass(Class<?> implementationClass) {
        this.implementationClass = implementationClass;
        return this;
    }

    public SerializerBuilder withCompatibilityLevel(CompatibilityLevel compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    public SerializerBuilder withAnnotationCompatibilityMode() {
        return this.withAnnotationCompatibilityMode(true);
    }

    public SerializerBuilder withAnnotationCompatibilityMode(boolean annotationsCompatibilityMode) {
        this.annotationsCompatibilityMode = annotationsCompatibilityMode;
        return this;
    }

    public <A extends Annotation, T extends Annotation> SerializerBuilder withAnnotationAlias(Class<A> annotation, Class<T> annotationAlias, Function<T, A> mapping) {
        this.annotationAliases.computeIfAbsent(annotation, $ -> new HashMap()).put(annotationAlias, mapping);
        return this;
    }

    public SerializerBuilder withEncodeVersion(int encodeVersionMax) {
        this.encodeVersionMax = encodeVersionMax;
        return this;
    }

    public SerializerBuilder withDecodeVersions(int decodeVersionMin, int decodeVersionMax) {
        this.decodeVersionMin = decodeVersionMin;
        this.decodeVersionMax = decodeVersionMax;
        return this;
    }

    public SerializerBuilder withVersions(int encodeVersionMax, int decodeVersionMin, int decodeVersionMax) {
        this.encodeVersionMax = encodeVersionMax;
        this.decodeVersionMin = decodeVersionMin;
        this.decodeVersionMax = decodeVersionMax;
        return this;
    }

    public SerializerBuilder withAutoOrdering(int autoOrderingStart, int autoOrderingStride) {
        this.autoOrderingStart = autoOrderingStart;
        this.autoOrderingStride = autoOrderingStride;
        return this;
    }

    public SerializerBuilder withProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public <T> SerializerBuilder withSubclasses(String subclassesId, List<Class<? extends T>> subclasses) {
        this.extraSubclassesMap.put(subclassesId, subclasses);
        return this;
    }

    public <T> SerializerBuilder withSubclasses(Class<T> type, List<Class<? extends T>> subclasses) {
        this.extraSubclassesMap.put(type, subclasses);
        return this;
    }

    public <T> BinarySerializer<T> build(Type type) {
        return this.build(AnnotatedTypes.annotatedTypeOf((Type)type));
    }

    public <T> BinarySerializer<T> build(Class<T> type) {
        return this.build(AnnotatedTypes.annotatedTypeOf(type));
    }

    public <T> BinarySerializer<T> build(TypeT<T> typeT) {
        return this.build(typeT.getAnnotatedType());
    }

    public <T> BinarySerializer<T> build(AnnotatedType type) {
        return (BinarySerializer)this.classLoader.ensureClassAndCreateInstance(ClassKey.of(BinarySerializer.class, (Object[])new Object[]{type}), () -> {
            SerializerDef serializer = (SerializerDef)this.registry.scanner(new HashMap()).scan(type);
            return this.toClassBuilder(serializer);
        }, new Object[0]);
    }

    public <T> BinarySerializer<T> build(String className, Type type) {
        return this.build(className, AnnotatedTypes.annotatedTypeOf((Type)type));
    }

    public <T> BinarySerializer<T> build(String className, Class<T> type) {
        return this.build(className, AnnotatedTypes.annotatedTypeOf(type));
    }

    public <T> BinarySerializer<T> build(String className, TypeT<T> typeT) {
        return this.build(className, typeT.getAnnotatedType());
    }

    public <T> BinarySerializer<T> build(String className, AnnotatedType type) {
        return (BinarySerializer)this.classLoader.ensureClassAndCreateInstance(className, () -> {
            SerializerDef serializer = (SerializerDef)this.registry.scanner(new HashMap()).scan(type);
            return this.toClassBuilder(serializer);
        }, new Object[0]);
    }

    public <T> BinarySerializer<T> build(SerializerDef serializer) {
        return (BinarySerializer)this.toClassBuilder(serializer).defineClassAndCreateInstance(DefiningClassLoader.create(), new Object[0]);
    }

    public <T> ClassBuilder<BinarySerializer<T>> toClassBuilder(SerializerDef serializer) {
        ClassBuilder classBuilder = ClassBuilder.create(this.implementationClass, (Class[])new Class[]{BinarySerializer.class});
        final HashSet collectedVersions = new HashSet();
        final HashMap encoderInitializers = new HashMap();
        final HashMap decoderInitializers = new HashMap();
        final HashMap encoderFinalizers = new HashMap();
        final HashMap decoderFinalizers = new HashMap();
        final Set visited = Collections.newSetFromMap(new IdentityHashMap());
        SerializerDef.Visitor visitor = new SerializerDef.Visitor(){

            @Override
            public void visit(String serializerId, SerializerDef visitedSerializer) {
                if (!visited.add(visitedSerializer)) {
                    return;
                }
                collectedVersions.addAll(visitedSerializer.getVersions());
                encoderInitializers.putAll(visitedSerializer.getEncoderInitializer());
                decoderInitializers.putAll(visitedSerializer.getDecoderInitializer());
                encoderFinalizers.putAll(visitedSerializer.getEncoderFinalizer());
                decoderFinalizers.putAll(visitedSerializer.getDecoderFinalizer());
                visitedSerializer.accept(this);
            }
        };
        visitor.visit(serializer);
        Integer encodeVersion = collectedVersions.stream().filter(v -> v <= this.encodeVersionMax).max(Comparator.naturalOrder()).orElse(null);
        List<Integer> decodeVersions = collectedVersions.stream().filter(v -> v >= this.decodeVersionMin && v <= this.decodeVersionMax).sorted().collect(Collectors.toList());
        this.defineEncoders(classBuilder, serializer, encodeVersion, new ArrayList<Expression>(encoderInitializers.values()), new ArrayList<Expression>(encoderFinalizers.values()));
        this.defineDecoders(classBuilder, serializer, decodeVersions, new ArrayList<Expression>(decoderInitializers.values()), new ArrayList<Expression>(decoderFinalizers.values()));
        return classBuilder;
    }

    private void defineEncoders(ClassBuilder<?> classBuilder, SerializerDef serializer, @Nullable Integer encodeVersion, List<Expression> encoderInitializers, List<Expression> encoderFinalizers) {
        SerializerDef.StaticEncoders staticEncoders = SerializerBuilder.staticEncoders(classBuilder);
        classBuilder.withMethod("encode", Integer.TYPE, Arrays.asList(byte[].class, Integer.TYPE, Object.class), this.methodBody(encoderInitializers, encoderFinalizers, Expressions.let((Expression)Expressions.cast((Expression)Expressions.arg((int)2), serializer.getEncodeType()), data -> this.encoderImpl(serializer, encodeVersion, staticEncoders, (Expression)Expressions.arg((int)0), Expressions.arg((int)1), (Variable)data))));
        classBuilder.withMethod("encode", Void.TYPE, Arrays.asList(BinaryOutput.class, Object.class), this.methodBody(encoderInitializers, encoderFinalizers, Expressions.let((Expression)Expressions.call((Expression)Expressions.arg((int)0), (String)"array", (Expression[])new Expression[0]), buf -> Expressions.let((Expression)Expressions.call((Expression)Expressions.arg((int)0), (String)"pos", (Expression[])new Expression[0]), pos -> Expressions.let((Expression)Expressions.cast((Expression)Expressions.arg((int)1), serializer.getEncodeType()), data -> Expressions.sequence((Expression[])new Expression[]{this.encoderImpl(serializer, encodeVersion, staticEncoders, (Expression)buf, (Variable)pos, (Variable)data), Expressions.call((Expression)Expressions.arg((int)0), (String)"pos", (Expression[])new Expression[]{pos})}))))));
    }

    private Expression encoderImpl(SerializerDef serializer, @Nullable Integer encodeVersion, SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Variable data) {
        return Expressions.sequence((Expression[])new Expression[]{encodeVersion != null ? SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)((byte)encodeVersion.intValue()))) : Expressions.voidExp(), serializer.encoder(staticEncoders, buf, pos, (Expression)data, encodeVersion != null ? encodeVersion : 0, this.compatibilityLevel), pos});
    }

    private void defineDecoders(ClassBuilder<?> classBuilder, SerializerDef serializer, List<Integer> decodeVersions, List<Expression> decoderInitializers, List<Expression> decoderFinalizers) {
        SerializerDef.StaticDecoders staticDecoders = this.staticDecoders(classBuilder);
        Integer latestVersion = decodeVersions.isEmpty() ? null : decodeVersions.get(decodeVersions.size() - 1);
        classBuilder.withMethod("decode", Object.class, Collections.singletonList(BinaryInput.class), this.methodBody(decoderInitializers, decoderFinalizers, this.decodeImpl(serializer, latestVersion, staticDecoders, (Expression)Expressions.arg((int)0))));
        classBuilder.withMethod("decode", Object.class, Arrays.asList(byte[].class, Integer.TYPE), this.methodBody(decoderInitializers, decoderFinalizers, Expressions.let((Expression)Expressions.constructor(BinaryInput.class, (Expression[])new Expression[]{Expressions.arg((int)0), Expressions.arg((int)1)}), in -> this.decodeImpl(serializer, latestVersion, staticDecoders, (Expression)in))));
        classBuilder.withMethod("decodeEarlierVersions", serializer.getDecodeType(), Arrays.asList(BinaryInput.class, Byte.TYPE), Utils.get(() -> {
            ArrayList<Expression> listKey = new ArrayList<Expression>();
            ArrayList<Expression> listValue = new ArrayList<Expression>();
            for (int i = decodeVersions.size() - 2; i >= 0; --i) {
                int version = (Integer)decodeVersions.get(i);
                listKey.add(Expressions.value((Object)((byte)version)));
                listValue.add(Expressions.call((Expression)Expressions.self(), (String)("decodeVersion" + version), (Expression[])new Expression[]{Expressions.arg((int)0)}));
            }
            return Expressions.switchByKey((Expression)Expressions.arg((int)1), listKey, listValue, (Expression)Expressions.throwException(CorruptedDataException.class, (Expression)Expressions.concat((Expression[])new Expression[]{Expressions.value((Object)"Unsupported version: "), Expressions.arg((int)1), Expressions.value((Object)(", supported versions: " + decodeVersions))})));
        }));
        for (int i = decodeVersions.size() - 2; i >= 0; --i) {
            int version = decodeVersions.get(i);
            classBuilder.withMethod("decodeVersion" + version, serializer.getDecodeType(), Collections.singletonList(BinaryInput.class), Expressions.sequence((Expression[])new Expression[]{serializer.defineDecoder(staticDecoders, (Expression)Expressions.arg((int)0), version, this.compatibilityLevel)}));
        }
    }

    private Expression methodBody(List<Expression> initializers, List<Expression> finalizers, Expression body) {
        if (initializers.isEmpty() && finalizers.isEmpty()) {
            return body;
        }
        return finalizers.isEmpty() ? Expressions.sequence((Expression[])new Expression[]{Expressions.sequence(initializers), body}) : Expressions.sequence((Expression[])new Expression[]{Expressions.sequence(initializers), Expressions.let((Expression)body, v -> Expressions.sequence((Expression[])new Expression[]{Expressions.sequence((List)finalizers), v}))});
    }

    private Expression decodeImpl(SerializerDef serializer, Integer latestVersion, SerializerDef.StaticDecoders staticDecoders, Expression in) {
        return latestVersion == null ? serializer.decoder(staticDecoders, in, 0, this.compatibilityLevel) : Expressions.let((Expression)SerializerExpressions.readByte(in), version -> Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)version, (Expression)Expressions.value((Object)((byte)latestVersion.intValue()))), (Expression)serializer.decoder(staticDecoders, in, latestVersion, this.compatibilityLevel), (Expression)Expressions.call((Expression)Expressions.self(), (String)"decodeEarlierVersions", (Expression[])new Expression[]{in, version})));
    }

    private static SerializerDef.StaticEncoders staticEncoders(final ClassBuilder<?> classBuilder) {
        return new SerializerDef.StaticEncoders(){
            final Map<List<?>, String> defined = new HashMap();

            @Override
            public Expression define(SerializerDef serializerDef, Class<?> valueClazz, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
                List<Serializable> key = Arrays.asList(new Serializable[]{Integer.valueOf(System.identityHashCode(serializerDef)), Integer.valueOf(version), compatibilityLevel});
                String methodName = this.defined.get(key);
                if (methodName == null) {
                    int i = 1;
                    while (true) {
                        methodName = "encode_" + valueClazz.getSimpleName().replace('[', 's').replace(']', '_') + (i == 1 ? "" : "_" + i);
                        if (this.defined.values().stream().noneMatch(methodName::equals)) break;
                        ++i;
                    }
                    this.defined.put(key, methodName);
                    classBuilder.withStaticMethod(methodName, Integer.TYPE, Arrays.asList(byte[].class, Integer.TYPE, valueClazz), Expressions.sequence((Expression[])new Expression[]{serializerDef.encoder(this, BUF, POS, (Expression)VALUE, version, compatibilityLevel), POS}));
                }
                return Expressions.set((StoreDef)pos, (Expression)Expressions.staticCallSelf((String)methodName, (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, valueClazz)}));
            }
        };
    }

    private SerializerDef.StaticDecoders staticDecoders(final ClassBuilder<?> classBuilder) {
        return new SerializerDef.StaticDecoders(){
            final Map<List<?>, String> defined = new HashMap();

            @Override
            public Expression define(SerializerDef serializerDef, Class<?> valueClazz, Expression in, int version, CompatibilityLevel compatibilityLevel) {
                List<Serializable> key = Arrays.asList(new Serializable[]{Integer.valueOf(System.identityHashCode(serializerDef)), Integer.valueOf(version), compatibilityLevel});
                String methodName = this.defined.get(key);
                if (methodName == null) {
                    int i = 1;
                    while (true) {
                        methodName = "decode_" + valueClazz.getSimpleName().replace('[', 's').replace(']', '_') + "_V" + version + (i == 1 ? "" : "_" + i);
                        if (this.defined.values().stream().noneMatch(methodName::equals)) break;
                        ++i;
                    }
                    this.defined.put(key, methodName);
                    classBuilder.withStaticMethod(methodName, valueClazz, Collections.singletonList(BinaryInput.class), serializerDef.decoder(this, (Expression)IN, version, compatibilityLevel));
                }
                return Expressions.staticCallSelf((String)methodName, (Expression[])new Expression[]{in});
            }

            @Override
            public <T> Class<T> buildClass(ClassBuilder<T> classBuilder2) {
                return classBuilder2.defineClass(SerializerBuilder.this.classLoader);
            }
        };
    }

    private SerializerDef scan(TypeScannerRegistry.Context<SerializerDef> ctx) {
        SerializerDef serializer;
        Map cache = (Map)ctx.getContextValue();
        SerializerDef serializerDef = (SerializerDef)cache.get(ctx.getType());
        if (serializerDef != null) {
            return serializerDef;
        }
        ForwardingSerializerDefImpl forwardingSerializerDef = new ForwardingSerializerDefImpl();
        cache.put(ctx.getType(), forwardingSerializerDef);
        forwardingSerializerDef.serializerDef = serializer = this.doScan(ctx);
        cache.remove(ctx.getType(), forwardingSerializerDef);
        return serializer;
    }

    private SerializerDef doScan(TypeScannerRegistry.Context<SerializerDef> ctx) {
        Class rawClass = ctx.getRawType();
        if (rawClass.isAnonymousClass()) {
            throw new IllegalArgumentException("Class should not be anonymous");
        }
        if (rawClass.isLocalClass()) {
            throw new IllegalArgumentException("Class should not be local");
        }
        SerializerDefClass serializer = SerializerDefClass.create(rawClass);
        if (!rawClass.isInterface()) {
            this.scanClass(ctx, serializer);
        } else {
            this.scanInterface(ctx, serializer);
        }
        return serializer;
    }

    private void scanClass(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer) {
        AnnotatedType annotatedClassType = ctx.getAnnotatedType();
        Class rawClassType = AnnotatedTypes.getRawType((AnnotatedType)annotatedClassType);
        Function<TypeVariable<?>, AnnotatedType> bindings = AnnotatedTypes.getTypeBindings((AnnotatedType)annotatedClassType)::get;
        if (rawClassType.getSuperclass() != Object.class) {
            this.scanClass((TypeScannerRegistry.Context<SerializerDef>)ctx.push(AnnotatedTypes.bind((AnnotatedType)rawClassType.getAnnotatedSuperclass(), bindings)), serializer);
        }
        ArrayList<FoundSerializer> foundSerializers = new ArrayList<FoundSerializer>();
        this.scanFields(ctx, bindings, foundSerializers);
        this.scanGetters(ctx, bindings, foundSerializers);
        this.addMethodsAndGettersToClass(ctx, serializer, foundSerializers);
        this.scanSetters(ctx, serializer);
        this.scanFactories(ctx, serializer);
        this.scanConstructors(ctx, serializer);
        if (!Modifier.isAbstract(ctx.getRawType().getModifiers())) {
            serializer.addMatchingSetters();
        }
    }

    private void scanInterface(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer) {
        Function<TypeVariable<?>, AnnotatedType> bindings = AnnotatedTypes.getTypeBindings((AnnotatedType)ctx.getAnnotatedType())::get;
        ArrayList<FoundSerializer> foundSerializers = new ArrayList<FoundSerializer>();
        this.scanGetters(ctx, bindings, foundSerializers);
        this.addMethodsAndGettersToClass(ctx, serializer, foundSerializers);
        for (AnnotatedType superInterface : ctx.getRawType().getAnnotatedInterfaces()) {
            this.scanInterface((TypeScannerRegistry.Context<SerializerDef>)ctx.push(AnnotatedTypes.bind((AnnotatedType)superInterface, bindings)), serializer);
        }
    }

    private void addMethodsAndGettersToClass(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer, List<FoundSerializer> foundSerializers) {
        if (foundSerializers.stream().anyMatch(f -> f.order == Integer.MIN_VALUE)) {
            final Map foundFields = foundSerializers.stream().collect(Collectors.groupingBy(FoundSerializer::getName, Collectors.toList()));
            String pathToClass = ctx.getRawType().getName().replace('.', '/') + ".class";
            try (InputStream classInputStream = ctx.getRawType().getClassLoader().getResourceAsStream(pathToClass);){
                ClassReader cr = new ClassReader(Objects.requireNonNull(classInputStream));
                cr.accept(new ClassVisitor(524288){
                    int index;
                    {
                        super(arg0);
                        this.index = 0;
                    }

                    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                        List list = (List)foundFields.get(name);
                        if (list == null) {
                            return null;
                        }
                        for (FoundSerializer foundSerializer : list) {
                            if (!(foundSerializer.methodOrField instanceof Field)) continue;
                            foundSerializer.index = this.index++;
                            break;
                        }
                        return null;
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        List list = (List)foundFields.get(name);
                        if (list == null) {
                            return null;
                        }
                        for (FoundSerializer foundSerializer : list) {
                            if (!(foundSerializer.methodOrField instanceof Method) || !descriptor.equals(org.objectweb.asm.Type.getType((Method)((Method)foundSerializer.methodOrField)).getDescriptor())) continue;
                            foundSerializer.index = this.index++;
                            break;
                        }
                        return null;
                    }
                }, 7);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            for (FoundSerializer foundSerializer : foundSerializers) {
                if (foundSerializer.order != Integer.MIN_VALUE) continue;
                foundSerializer.order = this.autoOrderingStart + foundSerializer.index * this.autoOrderingStride;
            }
        }
        HashSet<Integer> orders = new HashSet<Integer>();
        for (FoundSerializer foundSerializer : foundSerializers) {
            if (orders.add(foundSerializer.order)) continue;
            throw new IllegalArgumentException(String.format("Duplicate order %s for %s in %s", foundSerializer.order, foundSerializer, serializer));
        }
        Collections.sort(foundSerializers);
        for (FoundSerializer foundSerializer : foundSerializers) {
            if (foundSerializer.methodOrField instanceof Method) {
                serializer.addGetter((Method)foundSerializer.methodOrField, foundSerializer.serializer, foundSerializer.added, foundSerializer.removed);
                continue;
            }
            if (foundSerializer.methodOrField instanceof Field) {
                serializer.addField((Field)foundSerializer.methodOrField, foundSerializer.serializer, foundSerializer.added, foundSerializer.removed);
                continue;
            }
            throw new AssertionError();
        }
    }

    private void scanFields(TypeScannerRegistry.Context<SerializerDef> ctx, Function<TypeVariable<?>, AnnotatedType> bindings, List<FoundSerializer> foundSerializers) {
        for (Field field : ctx.getRawType().getDeclaredFields()) {
            FoundSerializer foundSerializer = this.tryAddField(ctx, bindings, field);
            if (foundSerializer == null) continue;
            foundSerializers.add(foundSerializer);
        }
    }

    private void scanGetters(TypeScannerRegistry.Context<SerializerDef> ctx, Function<TypeVariable<?>, AnnotatedType> bindings, List<FoundSerializer> foundSerializers) {
        for (Method method : ctx.getRawType().getDeclaredMethods()) {
            FoundSerializer foundSerializer = this.tryAddGetter(ctx, bindings, method);
            if (foundSerializer == null) continue;
            foundSerializers.add(foundSerializer);
        }
    }

    private void scanSetters(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer) {
        for (Method method : ctx.getRawType().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length == 0) continue;
            ArrayList<String> fields = new ArrayList<String>(method.getParameterTypes().length);
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
                Deserialize annotation = this.getAnnotation(Deserialize.class, parameterAnnotations);
                if (annotation == null) continue;
                String field = annotation.value();
                fields.add(field);
            }
            if (fields.size() == method.getParameterTypes().length) {
                serializer.addSetter(method, fields);
                continue;
            }
            if (fields.isEmpty()) continue;
            throw new IllegalArgumentException("Fields should not be empty");
        }
    }

    private void scanFactories(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer) {
        Class factoryClassType = ctx.getRawType();
        for (Method factory : factoryClassType.getDeclaredMethods()) {
            if (ctx.getRawType() != factory.getReturnType() || factory.getParameterTypes().length == 0) continue;
            ArrayList<String> fields = new ArrayList<String>(factory.getParameterTypes().length);
            for (int i = 0; i < factory.getParameterTypes().length; ++i) {
                Annotation[] parameterAnnotations = factory.getParameterAnnotations()[i];
                Deserialize annotation = this.getAnnotation(Deserialize.class, parameterAnnotations);
                if (annotation == null) continue;
                String field = annotation.value();
                fields.add(field);
            }
            if (fields.size() == factory.getParameterTypes().length) {
                serializer.setFactory(factory, fields);
                continue;
            }
            if (fields.isEmpty()) continue;
            throw new IllegalArgumentException(String.format("@Deserialize is not fully specified for %s", fields));
        }
    }

    private void scanConstructors(TypeScannerRegistry.Context<SerializerDef> ctx, SerializerDefClass serializer) {
        boolean found = false;
        for (Constructor<?> constructor : ctx.getRawType().getDeclaredConstructors()) {
            ArrayList<String> fields = new ArrayList<String>(constructor.getParameterTypes().length);
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                Deserialize annotation = this.getAnnotation(Deserialize.class, constructor.getParameterAnnotations()[i]);
                if (annotation == null) continue;
                String field = annotation.value();
                fields.add(field);
            }
            if (constructor.getParameterTypes().length != 0 && fields.size() == constructor.getParameterTypes().length) {
                if (found) {
                    throw new IllegalArgumentException(String.format("Duplicate @Deserialize constructor %s", constructor));
                }
                found = true;
                serializer.setConstructor(constructor, fields);
                continue;
            }
            if (fields.isEmpty()) continue;
            throw new IllegalArgumentException(String.format("@Deserialize is not fully specified for %s", fields));
        }
    }

    private FoundSerializer tryAddField(TypeScannerRegistry.Context<SerializerDef> ctx, Function<TypeVariable<?>, AnnotatedType> bindings, Field field) {
        FoundSerializer result = this.findAnnotations(field, field.getAnnotations());
        if (result == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalArgumentException(String.format("Field %s must be public", field));
        }
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(String.format("Field %s must not be static", field));
        }
        if (Modifier.isTransient(field.getModifiers())) {
            throw new IllegalArgumentException(String.format("Field %s must not be transient", field));
        }
        result.serializer = (SerializerDef)ctx.scan(AnnotatedTypes.bind((AnnotatedType)(this.annotationsCompatibilityMode ? SerializerBuilder.annotateWithTypePath(field.getGenericType(), field.getAnnotations()) : field.getAnnotatedType()), bindings));
        return result;
    }

    @Nullable
    private FoundSerializer tryAddGetter(TypeScannerRegistry.Context<SerializerDef> ctx, Function<TypeVariable<?>, AnnotatedType> bindings, Method getter) {
        if (getter.isBridge()) {
            return null;
        }
        FoundSerializer result = this.findAnnotations(getter, getter.getAnnotations());
        if (result == null) {
            return null;
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            throw new IllegalArgumentException(String.format("Getter %s must be public", getter));
        }
        if (Modifier.isStatic(getter.getModifiers())) {
            throw new IllegalArgumentException(String.format("Getter %s must not be static", getter));
        }
        if (getter.getReturnType() == Void.TYPE || getter.getParameterTypes().length != 0) {
            throw new IllegalArgumentException(String.format("%s must be getter", getter));
        }
        result.serializer = (SerializerDef)ctx.scan(AnnotatedTypes.bind((AnnotatedType)(this.annotationsCompatibilityMode ? SerializerBuilder.annotateWithTypePath(getter.getGenericReturnType(), getter.getAnnotations()) : getter.getAnnotatedReturnType()), bindings));
        return result;
    }

    private static <AR extends Annotation, AV extends Annotation> void repeatable(Class<AR> arClass, Class<AV> avClass, Function<AR, ? extends AV[]> toValue, Function<AV, int[]> toPath) {
        REPEATABLES_VALUE.put(arClass, toValue);
        ANNOTATIONS_PATH.put(avClass, toPath);
    }

    private static AnnotatedType annotateWithTypePath(Type type, Annotation[] annotations) {
        return AnnotatedTypes.annotatedTypeOf((Type)type, ($, path) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIter.rewriteExpressions(StructuredIter.java:119)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Nullable
    private FoundSerializer findAnnotations(Object methodOrField, Annotation[] annotations) {
        SerializeProfiles profiles;
        int added = -1;
        int removed = -1;
        Serialize serialize = this.getAnnotation(Serialize.class, annotations);
        if (serialize != null) {
            added = serialize.added();
            removed = serialize.removed();
        }
        if ((profiles = this.getAnnotation(SerializeProfiles.class, annotations)) != null) {
            int removedProfile;
            if (!Arrays.asList(profiles.value()).contains(this.profile == null ? "" : this.profile)) {
                return null;
            }
            int addedProfile = this.getProfileVersion(profiles.value(), profiles.added());
            if (addedProfile != -1) {
                added = addedProfile;
            }
            if ((removedProfile = this.getProfileVersion(profiles.value(), profiles.removed())) != -1) {
                removed = removedProfile;
            }
        }
        return serialize != null ? new FoundSerializer(methodOrField, serialize.order(), added, removed) : null;
    }

    private int getProfileVersion(String[] profiles, int[] versions) {
        if (profiles == null || profiles.length == 0) {
            return -1;
        }
        for (int i = 0; i < profiles.length; ++i) {
            if (!Objects.equals(this.profile, profiles[i])) continue;
            if (i < versions.length) {
                return versions[i];
            }
            return -1;
        }
        return -1;
    }

    private static /* synthetic */ int[] lambda$annotateWithTypePath$51(Annotation av) {
        return null;
    }

    static {
        SerializerBuilder.repeatable(SerializeFixedSizes.class, SerializeFixedSize.class, SerializeFixedSizes::value, SerializeFixedSize::path);
        SerializerBuilder.repeatable(SerializeNullables.class, SerializeNullable.class, SerializeNullables::value, SerializeNullable::path);
        SerializerBuilder.repeatable(SerializeReferences.class, SerializeReference.class, SerializeReferences::value, SerializeReference::path);
        SerializerBuilder.repeatable(SerializeStringFormats.class, SerializeStringFormat.class, SerializeStringFormats::value, SerializeStringFormat::path);
        SerializerBuilder.repeatable(SerializeClasses.class, SerializeClass.class, SerializeClasses::value, SerializeClass::path);
        SerializerBuilder.repeatable(SerializeVarLengths.class, SerializeVarLength.class, SerializeVarLengths::value, SerializeVarLength::path);
    }

    static class ForwardingSerializerDefImpl
    extends ForwardingSerializerDef {
        SerializerDef serializerDef;

        ForwardingSerializerDefImpl() {
        }

        @Override
        protected SerializerDef serializer() {
            return this.serializerDef;
        }
    }

    private static final class FoundSerializer
    implements Comparable<FoundSerializer> {
        final Object methodOrField;
        int order;
        int index;
        final int added;
        final int removed;
        SerializerDef serializer;

        private FoundSerializer(Object methodOrField, int order, int added, int removed) {
            this.methodOrField = methodOrField;
            this.order = order;
            this.added = added;
            this.removed = removed;
        }

        public String getName() {
            if (this.methodOrField instanceof Field) {
                return ((Field)this.methodOrField).getName();
            }
            if (this.methodOrField instanceof Method) {
                return ((Method)this.methodOrField).getName();
            }
            throw new AssertionError();
        }

        private int fieldRank() {
            if (this.methodOrField instanceof Field) {
                return 1;
            }
            if (this.methodOrField instanceof Method) {
                return 2;
            }
            throw new AssertionError();
        }

        @Override
        public int compareTo(FoundSerializer o) {
            int result = Integer.compare(this.order, o.order);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this.fieldRank(), o.fieldRank());
            if (result != 0) {
                return result;
            }
            result = this.getName().compareTo(o.getName());
            return result;
        }

        public String toString() {
            return this.methodOrField.getClass().getSimpleName() + " " + this.getName();
        }
    }
}

