/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.OkHttpUtils;
import io.ably.lib.network.OkHttpWebSocketClient;
import io.ably.lib.network.WebSocketClient;
import io.ably.lib.network.WebSocketEngine;
import io.ably.lib.network.WebSocketEngineConfig;
import io.ably.lib.network.WebSocketListener;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class OkHttpWebSocketEngine
implements WebSocketEngine {
    private final WebSocketEngineConfig config;

    public OkHttpWebSocketEngine(WebSocketEngineConfig config) {
        this.config = config;
    }

    public WebSocketClient create(String url, WebSocketListener listener) {
        OkHttpClient.Builder connectionBuilder = new OkHttpClient.Builder();
        Request.Builder requestBuilder = new Request.Builder().url(url);
        OkHttpUtils.injectProxySetting(this.config.getProxy(), connectionBuilder);
        if (this.config.getSslSocketFactory() != null) {
            connectionBuilder.sslSocketFactory(this.config.getSslSocketFactory());
        }
        return new OkHttpWebSocketClient(connectionBuilder.build(), requestBuilder.build(), listener);
    }

    public boolean isPingListenerSupported() {
        return false;
    }
}

