/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.SummaryClientIdCounts;
import io.ably.lib.types.SummaryClientIdList;
import io.ably.lib.types.SummaryTotal;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class Summary {
    private static final String TAG = Summary.class.getName();
    private static final String TOTAL = "total";
    private static final String CLIENT_IDS = "clientIds";
    private static final String CLIPPED = "clipped";
    private static final String TOTAL_UNIDENTIFIED = "totalUnidentified";
    private static final String TOTAL_CLIENT_IDS = "totalClientIds";
    private final Map<String, JsonObject> typeToSummaryJson;

    public Summary(Map<String, JsonObject> typeToSummaryJson) {
        this.typeToSummaryJson = typeToSummaryJson;
    }

    public static Map<String, SummaryClientIdList> asSummaryDistinctV1(JsonObject jsonObject) {
        HashMap<String, SummaryClientIdList> summary = new HashMap<String, SummaryClientIdList>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            summary.put(key, Summary.asSummaryFlagV1(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        return summary;
    }

    public static Map<String, SummaryClientIdList> asSummaryUniqueV1(JsonObject jsonObject) {
        return Summary.asSummaryDistinctV1(jsonObject);
    }

    public static Map<String, SummaryClientIdCounts> asSummaryMultipleV1(JsonObject jsonObject) {
        HashMap<String, SummaryClientIdCounts> summary = new HashMap<String, SummaryClientIdCounts>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
            int total = value.get(TOTAL).getAsInt();
            HashMap<String, Integer> clientIds = new HashMap<String, Integer>();
            for (Map.Entry clientEntry : value.get(CLIENT_IDS).getAsJsonObject().entrySet()) {
                clientIds.put((String)clientEntry.getKey(), ((JsonElement)clientEntry.getValue()).getAsInt());
            }
            Integer totalUnidentified = Summary.tryReadIntField(value, TOTAL_UNIDENTIFIED);
            Integer totalClientIds = Summary.tryReadIntField(value, TOTAL_CLIENT_IDS);
            summary.put(key, new SummaryClientIdCounts(total, clientIds, totalUnidentified == null ? 0 : totalUnidentified, Summary.tryReadBooleanField(value, CLIPPED), totalClientIds == null ? total : totalClientIds));
        }
        return summary;
    }

    public static SummaryClientIdList asSummaryFlagV1(JsonObject jsonObject) {
        int total = jsonObject.get(TOTAL).getAsInt();
        List clientIds = (List)Serialisation.gson.fromJson(jsonObject.get(CLIENT_IDS), List.class);
        return new SummaryClientIdList(total, clientIds, Summary.tryReadBooleanField(jsonObject, CLIPPED));
    }

    public static SummaryTotal asSummaryTotalV1(JsonObject jsonObject) {
        int total = jsonObject.get(TOTAL).getAsInt();
        return new SummaryTotal(total);
    }

    private static boolean tryReadBooleanField(JsonObject jsonObject, String fieldName) {
        JsonElement fieldElement = jsonObject.get(fieldName);
        if (fieldElement != null && fieldElement.isJsonPrimitive() && fieldElement.getAsJsonPrimitive().isBoolean()) {
            return fieldElement.getAsBoolean();
        }
        return false;
    }

    private static Integer tryReadIntField(JsonObject jsonObject, String fieldName) {
        JsonElement fieldElement = jsonObject.get(fieldName);
        if (fieldElement != null && fieldElement.isJsonPrimitive() && fieldElement.getAsJsonPrimitive().isNumber()) {
            return fieldElement.getAsInt();
        }
        return null;
    }

    static Summary read(MessageUnpacker unpacker) {
        try {
            return Summary.read(Serialisation.msgpackToGson((Value)unpacker.unpackValue()));
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to read summary from MessagePack", e);
            return null;
        }
    }

    static Summary read(JsonElement json) {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
        }
        HashMap<String, JsonObject> typeToSummaryJson = new HashMap<String, JsonObject>();
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
            }
            typeToSummaryJson.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
        }
        return new Summary(typeToSummaryJson);
    }

    public JsonObject get(String annotationType) {
        return this.typeToSummaryJson.get(annotationType);
    }

    void write(MessagePacker packer) {
        Serialisation.gsonToMsgpack(this.toJsonTree(), packer);
    }

    JsonElement toJsonTree() {
        return Serialisation.gson.toJsonTree((Object)this);
    }

    public static class Serializer
    implements JsonSerializer<Summary>,
    JsonDeserializer<Summary> {
        public JsonElement serialize(Summary summary, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : summary.typeToSummaryJson.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return json;
        }

        public Summary deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Summary.read(json);
        }
    }
}

