/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.rest.DeviceDetails;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.util.Log;
import io.ably.lib.util.ParamsUtils;
import io.ably.lib.util.Serialisation;
import io.ably.lib.util.StringUtils;
import java.util.Arrays;
import java.util.Map;

public class PushBase {
    protected final AblyBase rest;
    public final Admin admin;

    public PushBase(AblyBase rest) {
        this.rest = rest;
        this.admin = new Admin(rest);
    }

    Param[] pushRequestHeaders(boolean forLocalDevice) {
        return HttpUtils.defaultAcceptHeaders(this.rest.options.useBinaryProtocol);
    }

    Param[] pushRequestHeaders(String deviceId) {
        return this.pushRequestHeaders(false);
    }

    public static class Admin {
        private static final String TAG = Admin.class.getName();
        public final DeviceRegistrations deviceRegistrations;
        public final ChannelSubscriptions channelSubscriptions;
        private final AblyBase rest;

        Admin(AblyBase rest) {
            this.rest = rest;
            this.deviceRegistrations = new DeviceRegistrations(rest);
            this.channelSubscriptions = new ChannelSubscriptions(rest);
        }

        public void publish(Param[] recipient, JsonObject payload) throws AblyException {
            this.publishImpl(recipient, payload).sync();
        }

        public void publishAsync(Param[] recipient, JsonObject payload, CompletionListener listener) {
            this.publishImpl(recipient, payload).async(new CompletionListener.ToCallback(listener));
        }

        private Http.Request<Void> publishImpl(final Param[] recipient, final JsonObject payload) {
            Log.v(TAG, "publishImpl(): recipient=" + Arrays.toString(recipient) + ", payload=" + payload);
            return this.rest.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    if (recipient == null || recipient.length == 0) {
                        throw AblyException.fromThrowable(new Exception("recipient cannot be empty"));
                    }
                    if (payload == null || payload.entrySet().isEmpty()) {
                        throw AblyException.fromThrowable(new Exception("payload cannot be empty"));
                    }
                    JsonObject recipientJson = new JsonObject();
                    for (Param param : recipient) {
                        recipientJson.addProperty(param.key, param.value);
                    }
                    JsonObject bodyJson = new JsonObject();
                    bodyJson.add("recipient", (JsonElement)recipientJson);
                    for (Map.Entry entry : payload.entrySet()) {
                        bodyJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                    HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)bodyJson, ((Admin)this).rest.options.useBinaryProtocol);
                    Param[] params = ParamsUtils.enrichParams(null, ((Admin)this).rest.options);
                    http.post("/push/publish", HttpUtils.defaultAcceptHeaders(((Admin)this).rest.options.useBinaryProtocol), params, body, null, true, callback);
                }
            });
        }
    }

    public static class ChannelSubscription {
        public final String channel;
        public final String deviceId;
        public final String clientId;
        private static Serialisation.FromJsonElement<ChannelSubscription> fromJsonElement = new Serialisation.FromJsonElement<ChannelSubscription>(){

            @Override
            public ChannelSubscription fromJsonElement(JsonElement e) {
                return ChannelSubscription.fromJsonObject((JsonObject)e);
            }
        };
        protected static HttpCore.ResponseHandler<ChannelSubscription> httpResponseHandler = new Serialisation.HttpResponseHandler<ChannelSubscription>(ChannelSubscription.class, fromJsonElement);
        protected static HttpCore.BodyHandler<ChannelSubscription> httpBodyHandler = new Serialisation.HttpBodyHandler<ChannelSubscription>(ChannelSubscription[].class, fromJsonElement);

        public static ChannelSubscription forDevice(String channel, String deviceId) {
            return new ChannelSubscription(channel, deviceId, null);
        }

        public static ChannelSubscription forClientId(String channel, String clientId) {
            return new ChannelSubscription(channel, null, clientId);
        }

        private ChannelSubscription(String channel, String deviceId, String clientId) {
            this.channel = channel;
            this.deviceId = deviceId;
            this.clientId = clientId;
        }

        public JsonObject toJsonObject() {
            JsonObject o = new JsonObject();
            o.addProperty("channel", this.channel);
            if (this.clientId != null) {
                o.addProperty("clientId", this.clientId);
            }
            if (this.deviceId != null) {
                o.addProperty("deviceId", this.deviceId);
            }
            return o;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChannelSubscription)) {
                return false;
            }
            ChannelSubscription other = (ChannelSubscription)o;
            JsonObject thisJson = this.toJsonObject();
            JsonObject otherJson = other.toJsonObject();
            return thisJson.equals((Object)otherJson);
        }

        public String toString() {
            return this.toJsonObject().toString();
        }

        public static ChannelSubscription fromJsonObject(JsonObject o) {
            return (ChannelSubscription)Serialisation.gson.fromJson((JsonElement)o, ChannelSubscription.class);
        }
    }

    public static class ChannelSubscriptions {
        private static final String TAG = ChannelSubscriptions.class.getName();
        private final AblyBase rest;

        public ChannelSubscription save(ChannelSubscription subscription) throws AblyException {
            return this.saveImpl(subscription).sync();
        }

        public void saveAsync(ChannelSubscription subscription, Callback<ChannelSubscription> callback) {
            this.saveImpl(subscription).async(callback);
        }

        protected Http.Request<ChannelSubscription> saveImpl(final ChannelSubscription subscription) {
            Log.v(TAG, "saveImpl(): subscription=" + subscription);
            final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)subscription.toJsonObject(), this.rest.options.useBinaryProtocol);
            return this.rest.http.request(new Http.Execute<ChannelSubscription>(){

                @Override
                public void execute(HttpScheduler http, Callback<ChannelSubscription> callback) throws AblyException {
                    Param[] params = ParamsUtils.enrichParams(null, ((ChannelSubscriptions)this).rest.options);
                    http.post("/push/channelSubscriptions", ((ChannelSubscriptions)this).rest.push.pushRequestHeaders(subscription.deviceId), params, body, ChannelSubscription.httpResponseHandler, true, callback);
                }
            });
        }

        public PaginatedResult<ChannelSubscription> list(Param[] params) throws AblyException {
            return this.listImpl(params).sync();
        }

        public void listAsync(Param[] params, Callback<AsyncPaginatedResult<ChannelSubscription>> callback) {
            this.listImpl(params).async(callback);
        }

        protected BasePaginatedQuery.ResultRequest<ChannelSubscription> listImpl(Param[] params) {
            Log.v(TAG, "listImpl(): params=" + Arrays.toString(params));
            String deviceId = HttpUtils.getParam(params, "deviceId");
            return new BasePaginatedQuery<ChannelSubscription>(this.rest.http, "/push/channelSubscriptions", this.rest.push.pushRequestHeaders(deviceId), params, ChannelSubscription.httpBodyHandler).get();
        }

        public void remove(ChannelSubscription subscription) throws AblyException {
            this.removeImpl(subscription).sync();
        }

        public void removeAsync(ChannelSubscription subscription, CompletionListener listener) {
            this.removeImpl(subscription).async(new CompletionListener.ToCallback(listener));
        }

        protected Http.Request<Void> removeImpl(ChannelSubscription subscription) {
            Log.v(TAG, "removeImpl(): subscription=" + subscription);
            Param[] params = new Param[]{new Param("channel", subscription.channel)};
            if (subscription.deviceId != null) {
                params = Param.push(params, "deviceId", subscription.deviceId);
            } else if (subscription.clientId != null) {
                params = Param.push(params, "clientId", subscription.clientId);
            } else {
                return this.rest.http.failedRequest(AblyException.fromThrowable(new Exception("ChannelSubscription cannot be for both a deviceId and a clientId")));
            }
            return this.removeWhereImpl(params);
        }

        public void removeWhere(Param[] params) throws AblyException {
            this.removeWhereImpl(params).sync();
        }

        public void removeWhereAsync(Param[] params, CompletionListener listener) {
            this.removeWhereImpl(params).async(new CompletionListener.ToCallback(listener));
        }

        protected Http.Request<Void> removeWhereImpl(Param[] params) {
            Log.v(TAG, "removeWhereImpl(): params=" + Arrays.toString(params));
            String deviceId = HttpUtils.getParam(params, "deviceId");
            final Param[] finalParams = ParamsUtils.enrichParams(params, this.rest.options);
            final Param[] finalHeaders = this.rest.push.pushRequestHeaders(deviceId);
            return this.rest.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    http.del("/push/channelSubscriptions", finalHeaders, finalParams, null, true, callback);
                }
            });
        }

        public PaginatedResult<String> listChannels(Param[] params) throws AblyException {
            return this.listChannelsImpl(params).sync();
        }

        public void listChannelsAsync(Param[] params, Callback<AsyncPaginatedResult<String>> callback) {
            this.listChannelsImpl(params).async(callback);
        }

        protected BasePaginatedQuery.ResultRequest<String> listChannelsImpl(Param[] params) {
            Log.v(TAG, "listChannelsImpl(): params=" + Arrays.toString(params));
            String deviceId = HttpUtils.getParam(params, "deviceId");
            return new BasePaginatedQuery<String>(this.rest.http, "/push/channels", this.rest.push.pushRequestHeaders(deviceId), params, StringUtils.httpBodyHandler).get();
        }

        ChannelSubscriptions(AblyBase rest) {
            this.rest = rest;
        }
    }

    public static class DeviceRegistrations {
        private static final String TAG = DeviceRegistrations.class.getName();
        private final AblyBase rest;

        public DeviceDetails save(DeviceDetails device) throws AblyException {
            return this.saveImpl(device).sync();
        }

        public void saveAsync(DeviceDetails device, Callback<DeviceDetails> callback) {
            this.saveImpl(device).async(callback);
        }

        protected Http.Request<DeviceDetails> saveImpl(final DeviceDetails device) {
            Log.v(TAG, "saveImpl(): device=" + device);
            final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.toJsonObject(), this.rest.options.useBinaryProtocol);
            return this.rest.http.request(new Http.Execute<DeviceDetails>(){

                @Override
                public void execute(HttpScheduler http, Callback<DeviceDetails> callback) {
                    Param[] params = ParamsUtils.enrichParams(null, ((DeviceRegistrations)this).rest.options);
                    http.put("/push/deviceRegistrations/" + device.id, ((DeviceRegistrations)this).rest.push.pushRequestHeaders(device.id), params, body, DeviceDetails.httpResponseHandler, true, callback);
                }
            });
        }

        public DeviceDetails get(String deviceId) throws AblyException {
            return this.getImpl(deviceId).sync();
        }

        public void getAsync(String deviceId, Callback<DeviceDetails> callback) {
            this.getImpl(deviceId).async(callback);
        }

        protected Http.Request<DeviceDetails> getImpl(final String deviceId) {
            Log.v(TAG, "getImpl(): deviceId=" + deviceId);
            return this.rest.http.request(new Http.Execute<DeviceDetails>(){

                @Override
                public void execute(HttpScheduler http, Callback<DeviceDetails> callback) throws AblyException {
                    Param[] params = ParamsUtils.enrichParams(null, ((DeviceRegistrations)this).rest.options);
                    http.get("/push/deviceRegistrations/" + deviceId, ((DeviceRegistrations)this).rest.push.pushRequestHeaders(deviceId), params, DeviceDetails.httpResponseHandler, true, callback);
                }
            });
        }

        public PaginatedResult<DeviceDetails> list(Param[] params) throws AblyException {
            return this.listImpl(params).sync();
        }

        public void listAsync(Param[] params, Callback<AsyncPaginatedResult<DeviceDetails>> callback) {
            this.listImpl(params).async(callback);
        }

        protected BasePaginatedQuery.ResultRequest<DeviceDetails> listImpl(Param[] params) {
            Log.v(TAG, "listImpl(): params=" + Arrays.toString(params));
            return new BasePaginatedQuery<DeviceDetails>(this.rest.http, "/push/deviceRegistrations", HttpUtils.defaultAcceptHeaders(this.rest.options.useBinaryProtocol), params, DeviceDetails.httpBodyHandler).get();
        }

        public void remove(DeviceDetails device) throws AblyException {
            this.remove(device.id);
        }

        public void removeAsync(DeviceDetails device, CompletionListener listener) {
            this.removeAsync(device.id, listener);
        }

        public void remove(String deviceId) throws AblyException {
            this.removeImpl(deviceId).sync();
        }

        public void removeAsync(String deviceId, CompletionListener listener) {
            this.removeImpl(deviceId).async(new CompletionListener.ToCallback(listener));
        }

        protected Http.Request<Void> removeImpl(final String deviceId) {
            Log.v(TAG, "removeImpl(): deviceId=" + deviceId);
            return this.rest.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    Param[] params = ParamsUtils.enrichParams(null, ((DeviceRegistrations)this).rest.options);
                    http.del("/push/deviceRegistrations/" + deviceId, ((DeviceRegistrations)this).rest.push.pushRequestHeaders(deviceId), params, null, true, callback);
                }
            });
        }

        public void removeWhere(Param[] params) throws AblyException {
            this.removeWhereImpl(params).sync();
        }

        public void removeWhereAsync(Param[] params, CompletionListener listener) {
            this.removeWhereImpl(params).async(new CompletionListener.ToCallback(listener));
        }

        protected Http.Request<Void> removeWhereImpl(Param[] params) {
            Log.v(TAG, "removeWhereImpl(): params=" + Arrays.toString(params));
            final Param[] finalParams = ParamsUtils.enrichParams(params, this.rest.options);
            return this.rest.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    http.del("/push/deviceRegistrations", HttpUtils.defaultAcceptHeaders(((DeviceRegistrations)this).rest.options.useBinaryProtocol), finalParams, null, true, callback);
                }
            });
        }

        DeviceRegistrations(AblyBase rest) {
            this.rest = rest;
        }
    }
}

