/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelMode;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Crypto;
import java.util.Map;

public class ChannelOptions {
    public Map<String, String> params;
    public ChannelMode[] modes;
    private Crypto.ChannelCipherSet cipherSet;
    public Object cipherParams;
    public boolean encrypted;

    public boolean hasModes() {
        return null != this.modes && 0 != this.modes.length;
    }

    public boolean hasParams() {
        return null != this.params && !this.params.isEmpty();
    }

    public int getModeFlags() {
        int flags = 0;
        for (ChannelMode mode : this.modes) {
            flags |= mode.getMask();
        }
        return flags;
    }

    @Deprecated
    public Crypto.ChannelCipher getCipher() throws AblyException {
        return new Crypto.ChannelCipher(){

            @Override
            public byte[] encrypt(byte[] plaintext) throws AblyException {
                return ChannelOptions.this.getCipherSet().getEncipher().encrypt(plaintext);
            }

            @Override
            public byte[] decrypt(byte[] ciphertext) throws AblyException {
                return ChannelOptions.this.getCipherSet().getDecipher().decrypt(ciphertext);
            }

            @Override
            public String getAlgorithm() {
                try {
                    return ChannelOptions.this.getCipherSet().getEncipher().getAlgorithm();
                }
                catch (AblyException e) {
                    throw new IllegalStateException("Unexpected exception when using legacy crypto cipher interface.", e);
                }
            }
        };
    }

    public synchronized Crypto.ChannelCipherSet getCipherSet() throws AblyException {
        if (!this.encrypted) {
            throw new IllegalStateException("ChannelOptions encrypted field value is false.");
        }
        if (null == this.cipherSet) {
            this.cipherSet = Crypto.createChannelCipherSet(this.cipherParams);
        }
        return this.cipherSet;
    }

    @Deprecated
    public static ChannelOptions fromCipherKey(byte[] key) throws AblyException {
        return ChannelOptions.withCipherKey(key);
    }

    @Deprecated
    public static ChannelOptions fromCipherKey(String base64Key) throws AblyException {
        return ChannelOptions.fromCipherKey(Base64Coder.decode(base64Key));
    }

    public static ChannelOptions withCipherKey(byte[] key) throws AblyException {
        ChannelOptions options = new ChannelOptions();
        options.encrypted = true;
        options.cipherParams = Crypto.getDefaultParams(key);
        return options;
    }

    public static ChannelOptions withCipherKey(String base64Key) throws AblyException {
        return ChannelOptions.withCipherKey(Base64Coder.decode(base64Key));
    }
}

