/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.CloseableExecutor;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.util.Log;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHttpScheduler
extends HttpScheduler {
    private static final long KEEP_ALIVE_TIME = 2000L;
    protected static final String TAG = AsyncHttpScheduler.class.getName();

    public AsyncHttpScheduler(HttpCore httpCore, ClientOptions options) {
        super(httpCore, new CloseableThreadPoolExecutor(options));
    }

    private static class CloseableThreadPoolExecutor
    implements CloseableExecutor {
        private final ThreadPoolExecutor executor;

        CloseableThreadPoolExecutor(ClientOptions options) {
            this.executor = new ThreadPoolExecutor(options.asyncHttpThreadpoolSize, options.asyncHttpThreadpoolSize, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public void close() throws Exception {
            int drainedCount = this.executor.shutdownNow().size();
            if (drainedCount > 0) {
                Log.w(TAG, "close() drained (cancelled) task count: " + drainedCount);
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

