/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.AblyException;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Crypto;

public class ChannelOptions {
    public boolean encrypted;
    public Object cipherParams;
    private Crypto.ChannelCipher cipher;

    public Crypto.ChannelCipher getCipher() throws AblyException {
        if (!this.encrypted) {
            return null;
        }
        if (this.cipher != null) {
            return this.cipher;
        }
        this.cipher = Crypto.getCipher(this);
        return this.cipher;
    }

    public static ChannelOptions fromCipherKey(byte[] key) throws AblyException {
        ChannelOptions options = new ChannelOptions();
        options.encrypted = true;
        options.cipherParams = Crypto.getDefaultParams(key);
        options.cipher = Crypto.getCipher(options);
        return options;
    }

    public static ChannelOptions fromCipherKey(String base64Key) throws AblyException {
        return ChannelOptions.fromCipherKey(Base64Coder.decode(base64Key));
    }
}

