/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.rest.Auth;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageAction;
import io.ably.lib.types.MessageOperation;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.MessageVersion;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.UpdateDeleteResult;
import io.ably.lib.util.Crypto;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NonBlocking;

public class MessageEditsMixin {
    private final String basePath;
    private final ClientOptions clientOptions;
    private final ChannelOptions channelOptions;
    private final Auth auth;

    public MessageEditsMixin(String basePath, ClientOptions clientOptions, ChannelOptions channelOptions, Auth auth) {
        this.basePath = basePath;
        this.clientOptions = clientOptions;
        this.channelOptions = channelOptions;
        this.auth = auth;
    }

    @Blocking
    public Message getMessage(Http http, String serial) throws AblyException {
        return this.getMessageImpl(http, serial).sync();
    }

    @NonBlocking
    public void getMessageAsync(Http http, String serial, Callback<Message> callback) {
        this.getMessageImpl(http, serial).async(callback);
    }

    private Http.Request<Message> getMessageImpl(Http http, String serial) {
        return http.request((scheduler, callback) -> {
            if (serial == null || serial.isEmpty()) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
            }
            HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getSingleMessageResponseHandler(this.channelOptions);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            scheduler.get(this.basePath + "/messages/" + HttpUtils.encodeURIComponent(serial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, (response, error) -> {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                Message[] messages = (Message[])bodyHandler.handleResponseBody(response.contentType, response.body);
                if (messages != null && messages.length > 0) {
                    return messages[0];
                }
                throw AblyException.fromErrorInfo(new ErrorInfo("Message not found", 404, 40400));
            }, true, callback);
        });
    }

    @Blocking
    public UpdateDeleteResult updateMessage(Http http, Message message, MessageOperation operation) throws AblyException {
        return this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_UPDATE).sync();
    }

    @NonBlocking
    public void updateMessageAsync(Http http, Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_UPDATE).async(callback);
    }

    @Blocking
    public UpdateDeleteResult deleteMessage(Http http, Message message, MessageOperation operation) throws AblyException {
        return this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_DELETE).sync();
    }

    @NonBlocking
    public void deleteMessageAsync(Http http, Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_DELETE).async(callback);
    }

    @Blocking
    public UpdateDeleteResult appendMessage(Http http, Message message, MessageOperation operation) throws AblyException {
        return this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_APPEND).sync();
    }

    @NonBlocking
    public void appendMessageAsync(Http http, Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.updateMessageImpl(http, message, operation, MessageAction.MESSAGE_APPEND).async(callback);
    }

    private Http.Request<UpdateDeleteResult> updateMessageImpl(Http http, Message message, MessageOperation operation, MessageAction action) {
        return http.request((scheduler, callback) -> {
            if (message.serial == null || message.serial.isEmpty()) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
            }
            this.auth.checkClientId(message, true, false);
            Message updatedMessage = new Message(message.name, message.data, message.extras);
            updatedMessage.action = action;
            updatedMessage.version = new MessageVersion();
            if (operation != null) {
                updatedMessage.version.clientId = operation.clientId;
                updatedMessage.version.description = operation.description;
                updatedMessage.version.metadata = operation.metadata;
            }
            updatedMessage.encode(this.channelOptions);
            HttpCore.RequestBody requestBody = this.clientOptions.useBinaryProtocol ? MessageSerializer.asSingleMsgpackRequest(updatedMessage) : MessageSerializer.asSingleJsonRequest(updatedMessage);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            HttpCore.BodyHandler<UpdateDeleteResult> bodyHandler = UpdateDeleteResult.getBodyHandler();
            scheduler.patch(this.basePath + "/messages/" + HttpUtils.encodeURIComponent(message.serial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, requestBody, (response, error) -> {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                UpdateDeleteResult[] results = (UpdateDeleteResult[])bodyHandler.handleResponseBody(response.contentType, response.body);
                if (results != null && results.length > 0) {
                    return results[0];
                }
                throw AblyException.fromErrorInfo(new ErrorInfo("No versionSerial in the response", 500, 50000));
            }, true, callback);
        });
    }

    @Blocking
    public PaginatedResult<Message> getMessageVersions(Http http, String serial, Param[] params) throws AblyException {
        return this.getMessageVersionsImpl(http, serial, params).sync();
    }

    @NonBlocking
    public void getMessageVersionsAsync(Http http, String serial, Param[] params, Callback<AsyncPaginatedResult<Message>> callback) throws AblyException {
        this.getMessageVersionsImpl(http, serial, params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> getMessageVersionsImpl(Http http, String serial, Param[] initialParams) throws AblyException {
        if (serial == null || serial.isEmpty()) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
        }
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.channelOptions);
        Param[] params = this.clientOptions.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
        return new BasePaginatedQuery<Message>(http, this.basePath + "/messages/" + HttpUtils.encodeURIComponent(serial) + "/versions", HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, bodyHandler).get();
    }
}

