/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;

public interface CompletionListener {
    public void onSuccess();

    public void onError(ErrorInfo var1);

    public static class FromCallback
    implements CompletionListener {
        private final Callback<Void> callback;

        public FromCallback(Callback<Void> callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess() {
            this.callback.onSuccess(null);
        }

        @Override
        public void onError(ErrorInfo reason) {
            this.callback.onError(reason);
        }
    }

    public static class ToCallback<T>
    implements Callback<T> {
        private CompletionListener listener;

        public ToCallback(CompletionListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(T v) {
            this.listener.onSuccess();
        }

        @Override
        public void onError(ErrorInfo reason) {
            this.listener.onError(reason);
        }
    }

    public static class Multicaster
    extends io.ably.lib.util.Multicaster<CompletionListener>
    implements CompletionListener {
        public Multicaster(CompletionListener ... members) {
            super(members);
        }

        @Override
        public void onSuccess() {
            for (CompletionListener member : this.getMembers()) {
                try {
                    member.onSuccess();
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void onError(ErrorInfo reason) {
            for (CompletionListener member : this.getMembers()) {
                try {
                    member.onError(reason);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

