/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonObject;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.util.Map;
import org.msgpack.core.MessagePacker;

public class MessageOperation {
    private static final String CLIENT_ID = "clientId";
    private static final String DESCRIPTION = "description";
    private static final String METADATA = "metadata";
    public String clientId;
    public String description;
    public Map<String, String> metadata;

    public MessageOperation() {
    }

    public MessageOperation(String clientId, String description, Map<String, String> metadata) {
        this.clientId = clientId;
        this.description = description;
        this.metadata = metadata;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 0;
        if (this.clientId != null) {
            ++fieldCount;
        }
        if (this.description != null) {
            ++fieldCount;
        }
        if (this.metadata != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if (this.clientId != null) {
            packer.packString(CLIENT_ID);
            packer.packString(this.clientId);
        }
        if (this.description != null) {
            packer.packString(DESCRIPTION);
            packer.packString(this.description);
        }
        if (this.metadata != null) {
            packer.packString(METADATA);
            MessageSerializer.write(this.metadata, packer);
        }
    }

    JsonObject asJsonObject() {
        JsonObject json = new JsonObject();
        if (this.clientId != null) {
            json.addProperty(CLIENT_ID, this.clientId);
        }
        if (this.description != null) {
            json.addProperty(DESCRIPTION, this.description);
        }
        if (this.metadata != null) {
            json.add(METADATA, Serialisation.gson.toJsonTree(this.metadata));
        }
        return json;
    }
}

