/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.Auth;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageOperation;
import io.ably.lib.types.MessageOperationSerializer;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.util.Crypto;

public class MessageEditsMixin {
    private final String basePath;
    private final ClientOptions clientOptions;
    private final ChannelOptions channelOptions;
    private final Auth auth;

    public MessageEditsMixin(String basePath, ClientOptions clientOptions, ChannelOptions channelOptions, Auth auth) {
        this.basePath = basePath;
        this.clientOptions = clientOptions;
        this.channelOptions = channelOptions;
        this.auth = auth;
    }

    public Message getMessage(Http http, String serial) throws AblyException {
        return this.getMessageImpl(http, serial).sync();
    }

    public void getMessageAsync(Http http, String serial, Callback<Message> callback) {
        this.getMessageImpl(http, serial).async(callback);
    }

    private Http.Request<Message> getMessageImpl(Http http, String serial) {
        return http.request((scheduler, callback) -> {
            if (serial == null || serial.isEmpty()) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
            }
            HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getSingleMessageResponseHandler(this.channelOptions);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            scheduler.get(this.basePath + "/messages/" + HttpUtils.encodeURIComponent(serial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, (response, error) -> {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                Message[] messages = (Message[])bodyHandler.handleResponseBody(response.contentType, response.body);
                if (messages != null && messages.length > 0) {
                    return messages[0];
                }
                throw AblyException.fromErrorInfo(new ErrorInfo("Message not found", 404, 40400));
            }, true, callback);
        });
    }

    public void updateMessage(Http http, Message message, MessageOperation operation) throws AblyException {
        this.updateMessageImpl(http, message, operation).sync();
    }

    public void updateMessageAsync(Http http, Message message, MessageOperation operation, CompletionListener listener) {
        this.updateMessageImpl(http, message, operation).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> updateMessageImpl(Http http, Message message, MessageOperation operation) {
        return http.request((scheduler, callback) -> {
            if (message.serial == null || message.serial.isEmpty()) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
            }
            this.auth.checkClientId(message, true, false);
            HttpCore.RequestBody requestBody = this.clientOptions.useBinaryProtocol ? MessageOperationSerializer.asMsgPackRequest(message, operation, this.channelOptions) : MessageOperationSerializer.asJsonRequest(message, operation, this.channelOptions);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            scheduler.patch(this.basePath + "/messages/" + HttpUtils.encodeURIComponent(message.serial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, requestBody, null, true, callback);
        });
    }

    public void deleteMessage(Http http, Message message, MessageOperation operation) throws AblyException {
        this.deleteMessageImpl(http, message, operation).sync();
    }

    public void deleteMessageAsync(Http http, Message message, MessageOperation operation, CompletionListener listener) {
        this.deleteMessageImpl(http, message, operation).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> deleteMessageImpl(Http http, Message message, MessageOperation operation) {
        return http.request((scheduler, callback) -> {
            if (message.serial == null || message.serial.isEmpty()) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
            }
            this.auth.checkClientId(message, true, false);
            HttpCore.RequestBody requestBody = this.clientOptions.useBinaryProtocol ? MessageOperationSerializer.asMsgPackRequest(message, operation, this.channelOptions) : MessageOperationSerializer.asJsonRequest(message, operation, this.channelOptions);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            scheduler.post(this.basePath + "/messages/" + HttpUtils.encodeURIComponent(message.serial) + "/delete", HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, requestBody, null, true, callback);
        });
    }

    public PaginatedResult<Message> getMessageVersions(Http http, String serial, Param[] params) throws AblyException {
        return this.getMessageVersionsImpl(http, serial, params).sync();
    }

    public void getMessageVersionsAsync(Http http, String serial, Param[] params, Callback<AsyncPaginatedResult<Message>> callback) throws AblyException {
        this.getMessageVersionsImpl(http, serial, params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> getMessageVersionsImpl(Http http, String serial, Param[] initialParams) throws AblyException {
        if (serial == null || serial.isEmpty()) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Message serial cannot be empty", 400, 40003));
        }
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.channelOptions);
        Param[] params = this.clientOptions.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
        return new BasePaginatedQuery<Message>(http, this.basePath + "/messages/" + HttpUtils.encodeURIComponent(serial) + "/versions", HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, bodyHandler).get();
    }
}

