/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class MessageVersion {
    private static final String TAG = MessageVersion.class.getName();
    private static final String SERIAL = "serial";
    private static final String TIMESTAMP = "timestamp";
    private static final String CLIENT_ID = "clientId";
    private static final String DESCRIPTION = "description";
    private static final String METADATA = "metadata";
    public String serial;
    public long timestamp;
    public String clientId;
    public String description;
    public Map<String, String> metadata;

    public MessageVersion() {
    }

    public MessageVersion(String serial, Long timestamp) {
        this.serial = serial;
        this.timestamp = timestamp;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 0;
        if (this.serial != null) {
            ++fieldCount;
        }
        if (this.timestamp != 0L) {
            ++fieldCount;
        }
        if (this.clientId != null) {
            ++fieldCount;
        }
        if (this.description != null) {
            ++fieldCount;
        }
        if (this.metadata != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if (this.serial != null) {
            packer.packString(SERIAL);
            packer.packString(this.serial);
        }
        if (this.timestamp != 0L) {
            packer.packString(TIMESTAMP);
            packer.packLong(this.timestamp);
        }
        if (this.clientId != null) {
            packer.packString(CLIENT_ID);
            packer.packString(this.clientId);
        }
        if (this.description != null) {
            packer.packString(DESCRIPTION);
            packer.packString(this.description);
        }
        if (this.metadata != null) {
            packer.packString(METADATA);
            packer.packMapHeader(this.metadata.size());
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                packer.packString(entry.getKey());
                packer.packString(entry.getValue());
            }
        }
    }

    static MessageVersion read(MessageUnpacker unpacker) throws IOException {
        MessageVersion version = new MessageVersion();
        int fieldCount = unpacker.unpackMapHeader();
        block14: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "serial": {
                    version.serial = unpacker.unpackString();
                    continue block14;
                }
                case "timestamp": {
                    version.timestamp = unpacker.unpackLong();
                    continue block14;
                }
                case "clientId": {
                    version.clientId = unpacker.unpackString();
                    continue block14;
                }
                case "description": {
                    version.description = unpacker.unpackString();
                    continue block14;
                }
                case "metadata": {
                    int mapSize = unpacker.unpackMapHeader();
                    version.metadata = new HashMap<String, String>(mapSize);
                    for (int j = 0; j < mapSize; ++j) {
                        String key = unpacker.unpackString();
                        String value = unpacker.unpackString();
                        version.metadata.put(key, value);
                    }
                    continue block14;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return version;
    }

    static MessageVersion read(JsonElement json) throws MessageDecodeException {
        if (!json.isJsonObject()) {
            throw MessageDecodeException.fromDescription("Expected an object but got \"" + json.getClass() + "\".");
        }
        MessageVersion version = new MessageVersion();
        JsonObject map = json.getAsJsonObject();
        version.serial = MessageVersion.readString(map, SERIAL);
        version.timestamp = MessageVersion.readLong(map, TIMESTAMP);
        version.clientId = MessageVersion.readString(map, CLIENT_ID);
        version.description = MessageVersion.readString(map, DESCRIPTION);
        if (map.has(METADATA)) {
            JsonObject metadataObject = map.getAsJsonObject(METADATA);
            version.metadata = new HashMap<String, String>();
            for (Map.Entry entry : metadataObject.entrySet()) {
                version.metadata.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return version;
    }

    private static String readString(JsonObject map, String key) {
        JsonElement element = map.get(key);
        return element != null && !element.isJsonNull() ? element.getAsString() : null;
    }

    private static long readLong(JsonObject map, String key) {
        JsonElement element = map.get(key);
        return element != null && !element.isJsonNull() ? element.getAsLong() : 0L;
    }

    JsonElement toJsonTree() {
        JsonObject json = new JsonObject();
        if (this.serial != null) {
            json.addProperty(SERIAL, this.serial);
        }
        if (this.timestamp != 0L) {
            json.addProperty(TIMESTAMP, (Number)this.timestamp);
        }
        if (this.clientId != null) {
            json.addProperty(CLIENT_ID, this.clientId);
        }
        if (this.description != null) {
            json.addProperty(DESCRIPTION, this.description);
        }
        if (this.metadata != null) {
            JsonObject metadataObject = new JsonObject();
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                metadataObject.addProperty(entry.getKey(), entry.getValue());
            }
            json.add(METADATA, (JsonElement)metadataObject);
        }
        return json;
    }

    @NotNull
    public String toString() {
        return "{MessageVersion serial=" + this.serial + ", timestamp=" + this.timestamp + "}";
    }

    public static class Serializer
    implements JsonSerializer<MessageVersion>,
    JsonDeserializer<MessageVersion> {
        public JsonElement serialize(MessageVersion version, Type typeOfMessage, JsonSerializationContext ctx) {
            return version.toJsonTree();
        }

        public MessageVersion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return MessageVersion.read(json);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, e.getMessage(), e);
                throw new JsonParseException("Failed to deserialize MessageVersion from JSON.", (Throwable)e);
            }
        }
    }
}

