/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import io.ably.lib.push.ActivationContext;
import io.ably.lib.push.Storage;

public class SharedPreferenceStorage
implements Storage {
    private final ActivationContext activationContext;

    public SharedPreferenceStorage(ActivationContext activationContext) {
        this.activationContext = activationContext;
    }

    private SharedPreferences sharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.activationContext.getContext());
    }

    @Override
    public void put(String key, String value) {
        this.sharedPreferences().edit().putString(key, value).apply();
    }

    @Override
    public void put(String key, int value) {
        this.sharedPreferences().edit().putInt(key, value).apply();
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.sharedPreferences().getString(key, defaultValue);
    }

    @Override
    public int get(String key, int defaultValue) {
        return this.sharedPreferences().getInt(key, defaultValue);
    }

    @Override
    public void clear(String[] keys) {
        SharedPreferences.Editor editor = this.activationContext.getPreferences().edit();
        for (String key : keys) {
            editor.remove(key);
        }
        editor.commit();
    }
}

