/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.util.Log;
import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public final class DeltaExtras {
    private static final String TAG = DeltaExtras.class.getName();
    public static final String FORMAT_VCDIFF = "vcdiff";
    private final String format;
    private final String from;

    public DeltaExtras(String format, String from) {
        if (null == format) {
            throw new IllegalArgumentException("format cannot be null.");
        }
        if (null == from) {
            throw new IllegalArgumentException("from cannot be null.");
        }
        this.format = format;
        this.from = from;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFrom() {
        return this.from;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        packer.packMapHeader(2);
        packer.packString("format");
        packer.packString(this.format);
        packer.packString("from");
        packer.packString(this.from);
    }

    static DeltaExtras fromMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        String format = null;
        String from = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName.equals("format")) {
                format = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals("from")) {
                from = unpacker.unpackString();
                continue;
            }
            Log.w(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return new DeltaExtras(format, from);
    }
}

