/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.push.ActivationContext;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.rest.DeviceDetails;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.types.RegistrationToken;
import io.ably.lib.util.IntentUtils;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayDeque;

public class ActivationStateMachine {
    protected final ActivationContext activationContext;
    private final Context context;
    public State current;
    public ArrayDeque<Event> pendingEvents;
    protected boolean handlingEvent;
    private static final String TAG = "AblyActivation";

    private LocalDevice getDevice() {
        return this.activationContext.getLocalDevice();
    }

    private void callActivatedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_ACTIVATE", reason);
    }

    private void callDeactivatedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_DEACTIVATE", reason);
    }

    private void callSyncRegistrationFailedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_UPDATE_FAILED", reason);
    }

    private void sendErrorIntent(String name, ErrorInfo error) {
        Intent intent = new Intent();
        IntentUtils.addErrorInfo(intent, error);
        this.sendIntent(name, intent);
    }

    private void invokeCustomRegistration(final DeviceDetails device, final boolean isNew) {
        this.registerOnceReceiver("PUSH_DEVICE_REGISTERED", new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ErrorInfo error = IntentUtils.getErrorInfo(intent);
                if (error == null) {
                    Log.i(ActivationStateMachine.TAG, "custom registration for " + device.id);
                    if (isNew) {
                        ActivationStateMachine.this.handleEvent(new GotDeviceRegistration(intent.getStringExtra("deviceIdentityToken")));
                    } else {
                        ActivationStateMachine.this.handleEvent(new RegistrationSynced());
                    }
                } else {
                    Log.e(ActivationStateMachine.TAG, "error from custom registration for " + device.id + ": " + error.toString());
                    if (isNew) {
                        ActivationStateMachine.this.handleEvent(new GettingDeviceRegistrationFailed(error));
                    } else {
                        ActivationStateMachine.this.handleEvent(new SyncRegistrationFailed(error));
                    }
                }
            }
        });
        Intent intent = new Intent();
        intent.putExtra("isNew", isNew);
        this.sendIntent("PUSH_REGISTER_DEVICE", intent);
    }

    private void invokeCustomDeregistration(final DeviceDetails device) {
        this.registerOnceReceiver("PUSH_DEVICE_DEREGISTERED", new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ErrorInfo error = IntentUtils.getErrorInfo(intent);
                if (error == null) {
                    Log.i(ActivationStateMachine.TAG, "custom deregistration for " + device.id);
                    ActivationStateMachine.this.handleEvent(new Deregistered());
                } else {
                    Log.e(ActivationStateMachine.TAG, "error from custom deregisterer for " + device.id + ": " + error.toString());
                    ActivationStateMachine.this.handleEvent(new DeregistrationFailed(error));
                }
            }
        });
        Intent intent = new Intent();
        this.sendIntent("PUSH_DEREGISTER_DEVICE", intent);
    }

    private void sendIntent(String name, Intent intent) {
        intent.setAction("io.ably.broadcast." + name);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    private void registerOnceReceiver(String name, final BroadcastReceiver receiver) {
        BroadcastReceiver onceReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this);
                receiver.onReceive(context, intent);
            }
        };
        IntentFilter filter = new IntentFilter("io.ably.broadcast." + name);
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(onceReceiver, filter);
    }

    protected void getRegistrationToken() {
        this.activationContext.getRegistrationToken(new Callback<String>(){

            @Override
            public void onSuccess(String token) {
                Log.i(ActivationStateMachine.TAG, "getInstanceId completed with new token");
                ActivationStateMachine.this.activationContext.onNewRegistrationToken(RegistrationToken.Type.FCM, token);
            }

            @Override
            public void onError(ErrorInfo error) {
                Log.e(ActivationStateMachine.TAG, "getInstanceId failed", AblyException.fromErrorInfo(error));
                ActivationStateMachine.this.handleEvent(new GettingPushDeviceDetailsFailed(error));
            }
        });
    }

    private void updateRegistration() {
        final LocalDevice device = this.activationContext.getLocalDevice();
        boolean useCustomRegistrar = this.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false);
        if (useCustomRegistrar) {
            this.invokeCustomRegistration(device, false);
        } else {
            AblyRest ably;
            try {
                ably = this.activationContext.getAbly();
            }
            catch (AblyException ae) {
                ErrorInfo reason = ae.errorInfo;
                Log.e(TAG, "exception registering " + device.id + ": " + reason.toString());
                this.handleEvent(new SyncRegistrationFailed(reason));
                return;
            }
            final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.pushRecipientJsonObject(), ably.options.useBinaryProtocol);
            ably.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    Param[] params = null;
                    if (ably.options.pushFullWait) {
                        params = Param.push(params, "fullWait", "true");
                    }
                    http.patch("/push/deviceRegistrations/" + device.id, ably.push.pushRequestHeaders(true), params, body, null, false, callback);
                }
            }).async(new Callback<Void>(){

                @Override
                public void onSuccess(Void response) {
                    Log.i(ActivationStateMachine.TAG, "updated registration " + device.id);
                    ActivationStateMachine.this.handleEvent(new RegistrationSynced());
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Log.e(ActivationStateMachine.TAG, "error updating registration " + device.id + ": " + reason.toString());
                    ActivationStateMachine.this.handleEvent(new SyncRegistrationFailed(reason));
                }
            });
        }
    }

    private void validateRegistration() {
        AblyRest ably;
        final LocalDevice device = this.activationContext.getLocalDevice();
        try {
            ably = this.activationContext.getAbly();
        }
        catch (AblyException ae) {
            ErrorInfo reason = ae.errorInfo;
            Log.e(TAG, "exception validating registration for " + device.id + ": " + reason.toString());
            this.handleEvent(new SyncRegistrationFailed(reason));
            return;
        }
        String presentClientId = ably.auth.clientId;
        if (presentClientId != null && device.clientId != null && !presentClientId.equals(device.clientId)) {
            ErrorInfo clientIdErr = new ErrorInfo("Activation failed: present clientId is not compatible with existing device registration", 400, 61002);
            this.handleEvent(new SyncRegistrationFailed(clientIdErr));
            return;
        }
        boolean useCustomRegistrar = this.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false);
        if (useCustomRegistrar) {
            this.invokeCustomRegistration(device, false);
        } else {
            ably.http.request(new Http.Execute<JsonObject>(){

                @Override
                public void execute(HttpScheduler http, Callback<JsonObject> callback) throws AblyException {
                    Param[] params = null;
                    if (ably.options.pushFullWait) {
                        params = Param.push(params, "fullWait", "true");
                    }
                    HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.toJsonObject(), ably.options.useBinaryProtocol);
                    http.put("/push/deviceRegistrations/" + device.id, ably.push.pushRequestHeaders(true), params, body, new Serialisation.HttpResponseHandler(), true, callback);
                }
            }).async(new Callback<JsonObject>(){

                @Override
                public void onSuccess(JsonObject response) {
                    Log.i(ActivationStateMachine.TAG, "updated registration " + device.id);
                    JsonPrimitive responseClientIdJson = response.getAsJsonPrimitive("clientId");
                    if (responseClientIdJson != null) {
                        String responseClientId = responseClientIdJson.getAsString();
                        if (device.clientId == null) {
                            ActivationStateMachine.this.activationContext.setClientId(responseClientId, false);
                        }
                    }
                    ActivationStateMachine.this.handleEvent(new RegistrationSynced());
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Log.e(ActivationStateMachine.TAG, "error validating registration " + device.id + ": " + reason.toString());
                    ActivationStateMachine.this.handleEvent(new SyncRegistrationFailed(reason));
                }
            });
        }
    }

    private void deregister() {
        final LocalDevice device = this.activationContext.getLocalDevice();
        if (this.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false)) {
            this.invokeCustomDeregistration(device);
        } else {
            AblyRest ably;
            try {
                ably = this.activationContext.getAbly();
            }
            catch (AblyException ae) {
                ErrorInfo reason = ae.errorInfo;
                Log.e(TAG, "exception registering " + device.id + ": " + reason.toString());
                this.handleEvent(new DeregistrationFailed(reason));
                return;
            }
            ably.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    Param[] params = new Param[]{};
                    if (ably.options.pushFullWait) {
                        params = Param.push(params, "fullWait", "true");
                    }
                    http.del("/push/deviceRegistrations/" + device.id, ably.push.pushRequestHeaders(true), params, null, true, callback);
                }
            }).async(new Callback<Void>(){

                @Override
                public void onSuccess(Void response) {
                    Log.i(ActivationStateMachine.TAG, "deregistered " + device.id);
                    ActivationStateMachine.this.handleEvent(new Deregistered());
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Log.e(ActivationStateMachine.TAG, "error deregistering " + device.id + ": " + reason.toString());
                    ActivationStateMachine.this.handleEvent(new DeregistrationFailed(reason));
                }
            });
        }
    }

    public ActivationStateMachine(ActivationContext activationContext) {
        this.activationContext = activationContext;
        this.context = activationContext.getContext();
        this.loadPersisted();
        this.handlingEvent = false;
    }

    private void loadPersisted() {
        this.current = this.getPersistedState();
        this.pendingEvents = this.getPersistedPendingEvents();
    }

    private void enqueueEvent(Event event) {
        Log.d(TAG, "enqueuing event: " + event.getClass().getSimpleName());
        this.pendingEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean handleEvent(Event event) {
        if (this.handlingEvent) {
            this.enqueueEvent(event);
            return true;
        }
        this.handlingEvent = true;
        try {
            Event pending;
            Log.d(TAG, String.format("handling event %s from %s", event.getClass().getSimpleName(), this.current.getClass().getSimpleName()));
            State maybeNext = this.current.transition(event);
            if (maybeNext == null) {
                this.enqueueEvent(event);
                boolean bl = true;
                return bl;
            }
            Log.d(TAG, String.format("transition: %s -(%s)-> %s", this.current.getClass().getSimpleName(), event.getClass().getSimpleName(), maybeNext.getClass().getSimpleName()));
            this.current = maybeNext;
            while ((pending = this.pendingEvents.peek()) != null) {
                Log.d(TAG, "attempting to consume pending event: " + pending.getClass().getSimpleName());
                maybeNext = this.current.transition(pending);
                if (maybeNext == null) break;
                this.pendingEvents.poll();
                Log.d(TAG, String.format("transition: %s -(%s)-> %s", this.current.getClass().getSimpleName(), pending.getClass().getSimpleName(), maybeNext.getClass().getSimpleName()));
                this.current = maybeNext;
            }
            boolean bl = this.persist();
            return bl;
        }
        finally {
            this.handlingEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset() {
        SharedPreferences.Editor editor = this.activationContext.getPreferences().edit();
        for (Field f : PersistKeys.class.getDeclaredFields()) {
            try {
                editor.remove((String)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            boolean bl = editor.commit();
            return bl;
        }
        finally {
            this.loadPersisted();
        }
    }

    private boolean persist() {
        SharedPreferences.Editor editor = this.activationContext.getPreferences().edit();
        if (this.current instanceof PersistentState) {
            editor.putString("ABLY_PUSH_CURRENT_STATE", this.current.getClass().getName());
        }
        editor.putInt("ABLY_PUSH_PENDING_EVENTS_LENGTH", this.pendingEvents.size());
        int i = 0;
        for (Event e : this.pendingEvents) {
            editor.putString(String.format("%s[%d]", "ABLY_PUSH_PENDING_EVENTS", i), e.getClass().getName());
            ++i;
        }
        return editor.commit();
    }

    private State getPersistedState() {
        try {
            String className = this.activationContext.getPreferences().getString("ABLY_PUSH_CURRENT_STATE", "");
            Class stateClass = className.endsWith("$AfterRegistrationUpdateFailed") ? AfterRegistrationSyncFailed.class : Class.forName(className);
            Constructor constructor = stateClass.getConstructor(ActivationStateMachine.class);
            return (State)constructor.newInstance(this);
        }
        catch (Exception e) {
            return new NotActivated(this);
        }
    }

    private ArrayDeque<Event> getPersistedPendingEvents() {
        int length = this.activationContext.getPreferences().getInt("ABLY_PUSH_PENDING_EVENTS_LENGTH", 0);
        ArrayDeque<Event> deque = new ArrayDeque<Event>(length);
        for (int i = 0; i < length; ++i) {
            try {
                String className = this.activationContext.getPreferences().getString(String.format("%s[%d]", "ABLY_PUSH_PENDING_EVENTS", i), "");
                Event event = (Event)Class.forName(className).newInstance();
                deque.add(event);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return deque;
    }

    public static class PersistKeys {
        public static final String CURRENT_STATE = "ABLY_PUSH_CURRENT_STATE";
        static final String PENDING_EVENTS_LENGTH = "ABLY_PUSH_PENDING_EVENTS_LENGTH";
        static final String PENDING_EVENTS_PREFIX = "ABLY_PUSH_PENDING_EVENTS";
        static final String PUSH_CUSTOM_REGISTRAR = "ABLY_PUSH_REGISTRATION_HANDLER";
    }

    private static abstract class PersistentState
    extends State {
        PersistentState(ActivationStateMachine machine) {
            super(machine);
        }
    }

    public static abstract class State {
        protected final ActivationStateMachine machine;

        public State(ActivationStateMachine machine) {
            this.machine = machine;
        }

        public abstract State transition(Event var1);
    }

    public static class WaitingForDeregistration
    extends State {
        private State previousState;

        public WaitingForDeregistration(ActivationStateMachine machine, State previousState) {
            super(machine);
            this.previousState = previousState;
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledDeactivate) {
                return this;
            }
            if (event instanceof Deregistered) {
                LocalDevice device = this.machine.getDevice();
                device.reset();
                this.machine.callDeactivatedCallback(null);
                return new NotActivated(this.machine);
            }
            if (event instanceof DeregistrationFailed) {
                this.machine.callDeactivatedCallback(((DeregistrationFailed)event).reason);
                return this.previousState;
            }
            return null;
        }
    }

    public static class AfterRegistrationSyncFailed
    extends PersistentState {
        public AfterRegistrationSyncFailed(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate || event instanceof GotPushDeviceDetails) {
                this.machine.validateRegistration();
                return new WaitingForRegistrationSync(this.machine, event);
            }
            if (event instanceof CalledDeactivate) {
                this.machine.deregister();
                return new WaitingForDeregistration(this.machine, this);
            }
            return null;
        }
    }

    public static class WaitingForRegistrationSync
    extends State {
        private final Event fromEvent;

        public WaitingForRegistrationSync(ActivationStateMachine machine, Event fromEvent) {
            super(machine);
            this.fromEvent = fromEvent;
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                if (this.fromEvent instanceof CalledActivate) {
                    return null;
                }
                this.machine.callActivatedCallback(null);
                return this;
            }
            if (event instanceof RegistrationSynced) {
                if (this.fromEvent instanceof CalledActivate) {
                    this.machine.callActivatedCallback(null);
                }
                return new WaitingForNewPushDeviceDetails(this.machine);
            }
            if (event instanceof SyncRegistrationFailed) {
                ErrorInfo reason = ((SyncRegistrationFailed)event).reason;
                if (this.fromEvent instanceof CalledActivate) {
                    this.machine.callActivatedCallback(reason);
                } else {
                    this.machine.callSyncRegistrationFailedCallback(reason);
                }
                return new AfterRegistrationSyncFailed(this.machine);
            }
            return null;
        }
    }

    public static class WaitingForNewPushDeviceDetails
    extends PersistentState {
        public WaitingForNewPushDeviceDetails(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                this.machine.callActivatedCallback(null);
                return this;
            }
            if (event instanceof CalledDeactivate) {
                LocalDevice device = this.machine.getDevice();
                this.machine.deregister();
                return new WaitingForDeregistration(this.machine, this);
            }
            if (event instanceof GotPushDeviceDetails) {
                this.machine.getDevice();
                this.machine.updateRegistration();
                return new WaitingForRegistrationSync(this.machine, event);
            }
            return null;
        }
    }

    public static class WaitingForDeviceRegistration
    extends State {
        public WaitingForDeviceRegistration(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                return this;
            }
            if (event instanceof GotDeviceRegistration) {
                LocalDevice device = this.machine.getDevice();
                device.setDeviceIdentityToken(((GotDeviceRegistration)event).deviceIdentityToken);
                this.machine.callActivatedCallback(null);
                return new WaitingForNewPushDeviceDetails(this.machine);
            }
            if (event instanceof GettingDeviceRegistrationFailed) {
                this.machine.callActivatedCallback(((GettingDeviceRegistrationFailed)event).reason);
                return new NotActivated(this.machine);
            }
            return null;
        }
    }

    public static class WaitingForPushDeviceDetails
    extends PersistentState {
        public WaitingForPushDeviceDetails(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                return this;
            }
            if (event instanceof CalledDeactivate) {
                this.machine.callDeactivatedCallback(null);
                return new NotActivated(this.machine);
            }
            if (event instanceof GettingPushDeviceDetailsFailed) {
                this.machine.callDeactivatedCallback(((GettingPushDeviceDetailsFailed)event).reason);
                return new NotActivated(this.machine);
            }
            if (event instanceof GotPushDeviceDetails) {
                final ActivationContext activationContext = this.machine.activationContext;
                final LocalDevice device = activationContext.getLocalDevice();
                boolean useCustomRegistrar = activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false);
                if (useCustomRegistrar) {
                    this.machine.invokeCustomRegistration(device, true);
                } else {
                    AblyRest ably;
                    try {
                        ably = activationContext.getAbly();
                    }
                    catch (AblyException ae) {
                        ErrorInfo reason = ae.errorInfo;
                        Log.e(ActivationStateMachine.TAG, "exception registering " + device.id + ": " + reason.toString());
                        this.machine.handleEvent(new GettingDeviceRegistrationFailed(reason));
                        return new NotActivated(this.machine);
                    }
                    final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.toJsonObject(), ably.options.useBinaryProtocol);
                    ably.http.request(new Http.Execute<JsonObject>(){

                        @Override
                        public void execute(HttpScheduler http, Callback<JsonObject> callback) throws AblyException {
                            Param[] params = null;
                            if (ably.options.pushFullWait) {
                                params = Param.push(null, "fullWait", "true");
                            }
                            http.post("/push/deviceRegistrations", HttpUtils.defaultAcceptHeaders(ably.options.useBinaryProtocol), params, body, new Serialisation.HttpResponseHandler(), true, callback);
                        }
                    }).async(new Callback<JsonObject>(){

                        @Override
                        public void onSuccess(JsonObject response) {
                            Log.i(ActivationStateMachine.TAG, "registered " + device.id);
                            JsonObject deviceIdentityTokenJson = response.getAsJsonObject("deviceIdentityToken");
                            if (deviceIdentityTokenJson == null) {
                                Log.e(ActivationStateMachine.TAG, "invalid device registration response (no deviceIdentityToken); deviceId = " + device.id);
                                WaitingForPushDeviceDetails.this.machine.handleEvent(new GettingDeviceRegistrationFailed(new ErrorInfo("Invalid deviceIdentityToken in response", 40000, 400)));
                                return;
                            }
                            JsonPrimitive responseClientIdJson = response.getAsJsonPrimitive("clientId");
                            if (responseClientIdJson != null) {
                                String responseClientId = responseClientIdJson.getAsString();
                                if (device.clientId == null) {
                                    activationContext.setClientId(responseClientId, false);
                                }
                            }
                            WaitingForPushDeviceDetails.this.machine.handleEvent(new GotDeviceRegistration(deviceIdentityTokenJson.getAsJsonPrimitive("token").getAsString()));
                        }

                        @Override
                        public void onError(ErrorInfo reason) {
                            Log.e(ActivationStateMachine.TAG, "error registering " + device.id + ": " + reason.toString());
                            WaitingForPushDeviceDetails.this.machine.handleEvent(new GettingDeviceRegistrationFailed(reason));
                        }
                    });
                }
                return new WaitingForDeviceRegistration(this.machine);
            }
            return null;
        }
    }

    public static class NotActivated
    extends PersistentState {
        public NotActivated(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledDeactivate) {
                this.machine.callDeactivatedCallback(null);
                return this;
            }
            if (event instanceof CalledActivate) {
                LocalDevice device = this.machine.getDevice();
                if (device.isRegistered()) {
                    this.machine.validateRegistration();
                    return new WaitingForRegistrationSync(this.machine, event);
                }
                if (device.getRegistrationToken() != null) {
                    this.machine.pendingEvents.add(new GotPushDeviceDetails());
                } else {
                    this.machine.getRegistrationToken();
                }
                if (!device.isCreated()) {
                    device.create();
                }
                return new WaitingForPushDeviceDetails(this.machine);
            }
            if (event instanceof GotPushDeviceDetails) {
                return this;
            }
            return null;
        }
    }

    public static abstract class ErrorEvent
    extends Event {
        public final ErrorInfo reason;

        ErrorEvent(ErrorInfo reason) {
            this.reason = reason;
        }
    }

    public static abstract class Event {
    }

    public static class DeregistrationFailed
    extends ErrorEvent {
        public DeregistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class Deregistered
    extends Event {
    }

    public static class SyncRegistrationFailed
    extends ErrorEvent {
        public SyncRegistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class RegistrationSynced
    extends Event {
    }

    public static class GettingPushDeviceDetailsFailed
    extends ErrorEvent {
        GettingPushDeviceDetailsFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class GettingDeviceRegistrationFailed
    extends ErrorEvent {
        GettingDeviceRegistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class GotDeviceRegistration
    extends Event {
        final String deviceIdentityToken;

        GotDeviceRegistration(String token) {
            this.deviceIdentityToken = token;
        }
    }

    public static class GotPushDeviceDetails
    extends Event {
    }

    public static class CalledDeactivate
    extends Event {
        static CalledDeactivate useCustomRegistrar(boolean useCustomRegistrar, SharedPreferences prefs) {
            prefs.edit().putBoolean("ABLY_PUSH_REGISTRATION_HANDLER", useCustomRegistrar).apply();
            return new CalledDeactivate();
        }
    }

    public static class CalledActivate
    extends Event {
        public static CalledActivate useCustomRegistrar(boolean useCustomRegistrar, SharedPreferences prefs) {
            prefs.edit().putBoolean("ABLY_PUSH_REGISTRATION_HANDLER", useCustomRegistrar).apply();
            return new CalledActivate();
        }
    }
}

