/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.push.ActivationContext;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.rest.DeviceDetails;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.types.RegistrationToken;
import io.ably.lib.util.IntentUtils;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayDeque;

public class ActivationStateMachine {
    private final ActivationContext activationContext;
    private final Context context;
    public State current;
    public ArrayDeque<Event> pendingEvents;
    private static final String TAG = "AblyActivation";

    private LocalDevice getDevice() {
        return this.activationContext.getLocalDevice();
    }

    private void callActivatedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_ACTIVATE", reason);
    }

    private void callDeactivatedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_DEACTIVATE", reason);
    }

    private void callUpdateRegistrationFailedCallback(ErrorInfo reason) {
        this.sendErrorIntent("PUSH_UPDATE_FAILED", reason);
    }

    private void sendErrorIntent(String name, ErrorInfo error) {
        Intent intent = new Intent();
        IntentUtils.addErrorInfo(intent, error);
        this.sendIntent(name, intent);
    }

    private void invokeCustomRegistration(final DeviceDetails device, final boolean isNew) {
        this.registerOnceReceiver("PUSH_DEVICE_REGISTERED", new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ErrorInfo error = IntentUtils.getErrorInfo(intent);
                if (error == null) {
                    Log.i(ActivationStateMachine.TAG, "custom registration for " + device.id);
                    if (isNew) {
                        ActivationStateMachine.this.handleEvent(new GotDeviceRegistration(intent.getStringExtra("deviceIdentityToken")));
                    } else {
                        ActivationStateMachine.this.handleEvent(new RegistrationUpdated());
                    }
                } else {
                    Log.e(ActivationStateMachine.TAG, "error from custom registration for " + device.id + ": " + error.toString());
                    if (isNew) {
                        ActivationStateMachine.this.handleEvent(new GettingDeviceRegistrationFailed(error));
                    } else {
                        ActivationStateMachine.this.handleEvent(new UpdatingRegistrationFailed(error));
                    }
                }
            }
        });
        Intent intent = new Intent();
        intent.putExtra("isNew", isNew);
        this.sendIntent("PUSH_REGISTER_DEVICE", intent);
    }

    private void invokeCustomDeregistration(final DeviceDetails device) {
        this.registerOnceReceiver("PUSH_DEVICE_DEREGISTERED", new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ErrorInfo error = IntentUtils.getErrorInfo(intent);
                if (error == null) {
                    Log.i(ActivationStateMachine.TAG, "custom deregistration for " + device.id);
                    ActivationStateMachine.this.handleEvent(new Deregistered());
                } else {
                    Log.e(ActivationStateMachine.TAG, "error from custom deregisterer for " + device.id + ": " + error.toString());
                    ActivationStateMachine.this.handleEvent(new DeregistrationFailed(error));
                }
            }
        });
        Intent intent = new Intent();
        this.sendIntent("PUSH_DEREGISTER_DEVICE", intent);
    }

    private void sendIntent(String name, Intent intent) {
        intent.setAction("io.ably.broadcast." + name);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    private void registerOnceReceiver(String name, final BroadcastReceiver receiver) {
        BroadcastReceiver onceReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this);
                receiver.onReceive(context, intent);
            }
        };
        IntentFilter filter = new IntentFilter("io.ably.broadcast." + name);
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(onceReceiver, filter);
    }

    private static void getRegistrationToken(final ActivationStateMachine machine) {
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(Task<InstanceIdResult> task) {
                if (task.isSuccessful()) {
                    String token = ((InstanceIdResult)task.getResult()).getToken();
                    Log.i(ActivationStateMachine.TAG, "getInstanceId completed with new token");
                    machine.activationContext.onNewRegistrationToken(RegistrationToken.Type.FCM, token);
                } else {
                    Log.e(ActivationStateMachine.TAG, "getInstanceId failed", task.getException());
                    machine.handleEvent(new GettingPushDeviceDetailsFailed(ErrorInfo.fromThrowable(task.getException())));
                }
            }
        });
    }

    private static void updateRegistration(final ActivationStateMachine machine) {
        final LocalDevice device = machine.activationContext.getLocalDevice();
        boolean useCustomRegistrar = machine.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false);
        if (useCustomRegistrar) {
            machine.invokeCustomRegistration(device, false);
        } else {
            AblyRest ably;
            try {
                ably = machine.activationContext.getAbly();
            }
            catch (AblyException ae) {
                ErrorInfo reason = ae.errorInfo;
                Log.e(TAG, "exception registering " + device.id + ": " + reason.toString());
                machine.handleEvent(new UpdatingRegistrationFailed(reason));
                return;
            }
            final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.pushRecipientJsonObject(), ably.options.useBinaryProtocol);
            ably.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    Param[] params = null;
                    if (ably.options.pushFullWait) {
                        params = Param.push(params, "fullWait", "true");
                    }
                    http.patch("/push/deviceRegistrations/" + device.id, ably.push.pushRequestHeaders(true), params, body, null, true, callback);
                }
            }).async(new Callback<Void>(){

                @Override
                public void onSuccess(Void response) {
                    Log.i(ActivationStateMachine.TAG, "updated registration " + device.id);
                    machine.handleEvent(new RegistrationUpdated());
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Log.e(ActivationStateMachine.TAG, "error updating registration " + device.id + ": " + reason.toString());
                    machine.handleEvent(new UpdatingRegistrationFailed(reason));
                }
            });
        }
    }

    private static void deregister(final ActivationStateMachine machine) {
        final LocalDevice device = machine.activationContext.getLocalDevice();
        if (machine.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false)) {
            machine.invokeCustomDeregistration(device);
        } else {
            AblyRest ably;
            try {
                ably = machine.activationContext.getAbly();
            }
            catch (AblyException ae) {
                ErrorInfo reason = ae.errorInfo;
                Log.e(TAG, "exception registering " + device.id + ": " + reason.toString());
                machine.handleEvent(new DeregistrationFailed(reason));
                return;
            }
            ably.http.request(new Http.Execute<Void>(){

                @Override
                public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                    Param[] params = new Param[]{};
                    if (ably.options.pushFullWait) {
                        params = Param.push(params, "fullWait", "true");
                    }
                    http.del("/push/deviceRegistrations/" + device.id, ably.push.pushRequestHeaders(true), params, null, true, callback);
                }
            }).async(new Callback<Void>(){

                @Override
                public void onSuccess(Void response) {
                    Log.i(ActivationStateMachine.TAG, "deregistered " + device.id);
                    machine.handleEvent(new Deregistered());
                }

                @Override
                public void onError(ErrorInfo reason) {
                    Log.e(ActivationStateMachine.TAG, "error deregistering " + device.id + ": " + reason.toString());
                    machine.handleEvent(new DeregistrationFailed(reason));
                }
            });
        }
    }

    public ActivationStateMachine(ActivationContext activationContext) {
        this.activationContext = activationContext;
        this.context = activationContext.getContext();
        this.current = this.getPersistedState();
        this.pendingEvents = this.getPersistedPendingEvents();
    }

    public synchronized boolean handleEvent(Event event) {
        Event pending;
        Log.d(TAG, String.format("handling event %s from %s", event.getClass().getSimpleName(), this.current.getClass().getSimpleName()));
        State maybeNext = this.current.transition(event);
        if (maybeNext == null) {
            Log.d(TAG, "enqueuing event: " + event.getClass().getSimpleName());
            this.pendingEvents.add(event);
            return true;
        }
        Log.d(TAG, String.format("transition: %s -(%s)-> %s", this.current.getClass().getSimpleName(), event.getClass().getSimpleName(), maybeNext.getClass().getSimpleName()));
        this.current = maybeNext;
        while ((pending = this.pendingEvents.peek()) != null) {
            Log.d(TAG, "attempting to consume pending event: " + pending.getClass().getSimpleName());
            maybeNext = this.current.transition(pending);
            if (maybeNext == null) break;
            this.pendingEvents.poll();
            Log.d(TAG, String.format("transition: %s -(%s)-> %s", this.current.getClass().getSimpleName(), pending.getClass().getSimpleName(), maybeNext.getClass().getSimpleName()));
            this.current = maybeNext;
        }
        return this.persist();
    }

    public boolean reset() {
        SharedPreferences.Editor editor = this.activationContext.getPreferences().edit();
        for (Field f : PersistKeys.class.getDeclaredFields()) {
            try {
                editor.remove((String)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return editor.commit();
    }

    private boolean persist() {
        SharedPreferences.Editor editor = this.activationContext.getPreferences().edit();
        if (this.current instanceof PersistentState) {
            editor.putString("ABLY_PUSH_CURRENT_STATE", this.current.getClass().getName());
        }
        editor.putInt("ABLY_PUSH_PENDING_EVENTS_LENGTH", this.pendingEvents.size());
        int i = 0;
        for (Event e : this.pendingEvents) {
            editor.putString(String.format("%s[%d]", "ABLY_PUSH_PENDING_EVENTS", i), e.getClass().getName());
            ++i;
        }
        return editor.commit();
    }

    private State getPersistedState() {
        try {
            Class<?> stateClass = Class.forName(this.activationContext.getPreferences().getString("ABLY_PUSH_CURRENT_STATE", ""));
            Constructor<?> constructor = stateClass.getConstructor(this.getClass());
            return (State)constructor.newInstance(this);
        }
        catch (Exception e) {
            return new NotActivated(this);
        }
    }

    private ArrayDeque<Event> getPersistedPendingEvents() {
        int length = this.activationContext.getPreferences().getInt("ABLY_PUSH_PENDING_EVENTS_LENGTH", 0);
        ArrayDeque<Event> deque = new ArrayDeque<Event>(length);
        for (int i = 0; i < length; ++i) {
            try {
                String className = this.activationContext.getPreferences().getString(String.format("%s[%d]", "ABLY_PUSH_PENDING_EVENTS", i), "");
                Event event = (Event)Class.forName(className).newInstance();
                deque.add(event);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return deque;
    }

    private static class PersistKeys {
        static final String CURRENT_STATE = "ABLY_PUSH_CURRENT_STATE";
        static final String PENDING_EVENTS_LENGTH = "ABLY_PUSH_PENDING_EVENTS_LENGTH";
        static final String PENDING_EVENTS_PREFIX = "ABLY_PUSH_PENDING_EVENTS";
        static final String PUSH_CUSTOM_REGISTRAR = "ABLY_PUSH_REGISTRATION_HANDLER";

        private PersistKeys() {
        }
    }

    private static abstract class PersistentState
    extends State {
        PersistentState(ActivationStateMachine machine) {
            super(machine);
        }
    }

    public static abstract class State {
        protected final ActivationStateMachine machine;

        public State(ActivationStateMachine machine) {
            this.machine = machine;
        }

        public abstract State transition(Event var1);
    }

    public static class WaitingForDeregistration
    extends State {
        private State previousState;

        public WaitingForDeregistration(ActivationStateMachine machine, State previousState) {
            super(machine);
            this.previousState = previousState;
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledDeactivate) {
                return this;
            }
            if (event instanceof Deregistered) {
                LocalDevice device = this.machine.getDevice();
                device.reset();
                this.machine.callDeactivatedCallback(null);
                return new NotActivated(this.machine);
            }
            if (event instanceof DeregistrationFailed) {
                this.machine.callDeactivatedCallback(((DeregistrationFailed)event).reason);
                return this.previousState;
            }
            return null;
        }
    }

    public static class AfterRegistrationUpdateFailed
    extends PersistentState {
        public AfterRegistrationUpdateFailed(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate || event instanceof GotPushDeviceDetails) {
                ActivationStateMachine.updateRegistration(this.machine);
                return new WaitingForRegistrationUpdate(this.machine);
            }
            if (event instanceof CalledDeactivate) {
                ActivationStateMachine.deregister(this.machine);
                return new WaitingForDeregistration(this.machine, this);
            }
            return null;
        }
    }

    public static class WaitingForRegistrationUpdate
    extends State {
        public WaitingForRegistrationUpdate(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                this.machine.callActivatedCallback(null);
                return this;
            }
            if (event instanceof RegistrationUpdated) {
                return new WaitingForNewPushDeviceDetails(this.machine);
            }
            if (event instanceof UpdatingRegistrationFailed) {
                this.machine.callUpdateRegistrationFailedCallback(((UpdatingRegistrationFailed)event).reason);
                return new AfterRegistrationUpdateFailed(this.machine);
            }
            return null;
        }
    }

    public static class WaitingForNewPushDeviceDetails
    extends PersistentState {
        public WaitingForNewPushDeviceDetails(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                this.machine.callActivatedCallback(null);
                return this;
            }
            if (event instanceof CalledDeactivate) {
                LocalDevice device = this.machine.getDevice();
                ActivationStateMachine.deregister(this.machine);
                return new WaitingForDeregistration(this.machine, this);
            }
            if (event instanceof GotPushDeviceDetails) {
                LocalDevice device = this.machine.getDevice();
                ActivationStateMachine.updateRegistration(this.machine);
                return new WaitingForRegistrationUpdate(this.machine);
            }
            return null;
        }
    }

    public static class WaitingForDeviceRegistration
    extends State {
        public WaitingForDeviceRegistration(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                return this;
            }
            if (event instanceof GotDeviceRegistration) {
                LocalDevice device = this.machine.getDevice();
                device.setDeviceIdentityToken(((GotDeviceRegistration)event).deviceIdentityToken);
                this.machine.callActivatedCallback(null);
                return new WaitingForNewPushDeviceDetails(this.machine);
            }
            if (event instanceof GettingDeviceRegistrationFailed) {
                this.machine.callActivatedCallback(((GettingDeviceRegistrationFailed)event).reason);
                return new NotActivated(this.machine);
            }
            return null;
        }
    }

    public static class WaitingForPushDeviceDetails
    extends PersistentState {
        public WaitingForPushDeviceDetails(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledActivate) {
                return this;
            }
            if (event instanceof CalledDeactivate) {
                this.machine.callDeactivatedCallback(null);
                return new NotActivated(this.machine);
            }
            if (event instanceof GettingPushDeviceDetailsFailed) {
                this.machine.callDeactivatedCallback(((GettingPushDeviceDetailsFailed)event).reason);
                return new NotActivated(this.machine);
            }
            if (event instanceof GotPushDeviceDetails) {
                final LocalDevice device = this.machine.getDevice();
                boolean useCustomRegistrar = this.machine.activationContext.getPreferences().getBoolean("ABLY_PUSH_REGISTRATION_HANDLER", false);
                if (useCustomRegistrar) {
                    this.machine.invokeCustomRegistration(device, true);
                } else {
                    AblyRest ably;
                    try {
                        ably = this.machine.activationContext.getAbly();
                    }
                    catch (AblyException ae) {
                        ErrorInfo reason = ae.errorInfo;
                        Log.e(ActivationStateMachine.TAG, "exception registering " + device.id + ": " + reason.toString());
                        this.machine.handleEvent(new GettingDeviceRegistrationFailed(reason));
                        return new NotActivated(this.machine);
                    }
                    final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)device.toJsonObject(), ably.options.useBinaryProtocol);
                    ably.http.request(new Http.Execute<JsonObject>(){

                        @Override
                        public void execute(HttpScheduler http, Callback<JsonObject> callback) throws AblyException {
                            Param[] params = null;
                            if (ably.options.pushFullWait) {
                                params = Param.push(null, "fullWait", "true");
                            }
                            http.post("/push/deviceRegistrations", HttpUtils.defaultAcceptHeaders(ably.options.useBinaryProtocol), params, body, new Serialisation.HttpResponseHandler(), true, callback);
                        }
                    }).async(new Callback<JsonObject>(){

                        @Override
                        public void onSuccess(JsonObject response) {
                            Log.i(ActivationStateMachine.TAG, "registered " + device.id);
                            JsonObject deviceIdentityTokenJson = response.getAsJsonObject("deviceIdentityToken");
                            if (deviceIdentityTokenJson == null) {
                                WaitingForPushDeviceDetails.this.machine.handleEvent(new GettingDeviceRegistrationFailed(new ErrorInfo("Invalid deviceIdentityToken in response", 40000, 400)));
                            } else {
                                WaitingForPushDeviceDetails.this.machine.handleEvent(new GotDeviceRegistration(deviceIdentityTokenJson.getAsJsonPrimitive("token").getAsString()));
                            }
                        }

                        @Override
                        public void onError(ErrorInfo reason) {
                            Log.e(ActivationStateMachine.TAG, "error registering " + device.id + ": " + reason.toString());
                            WaitingForPushDeviceDetails.this.machine.handleEvent(new GettingDeviceRegistrationFailed(reason));
                        }
                    });
                }
                return new WaitingForDeviceRegistration(this.machine);
            }
            return null;
        }
    }

    public static class NotActivated
    extends PersistentState {
        public NotActivated(ActivationStateMachine machine) {
            super(machine);
        }

        @Override
        public State transition(Event event) {
            if (event instanceof CalledDeactivate) {
                this.machine.callDeactivatedCallback(null);
                return this;
            }
            if (event instanceof CalledActivate) {
                LocalDevice device = this.machine.getDevice();
                if (device.isRegistered()) {
                    this.machine.pendingEvents.add(new CalledActivate());
                    return new WaitingForNewPushDeviceDetails(this.machine);
                }
                if (device.getRegistrationToken() != null) {
                    this.machine.pendingEvents.add(new GotPushDeviceDetails());
                } else {
                    ActivationStateMachine.getRegistrationToken(this.machine);
                }
                if (!device.isCreated()) {
                    device.create();
                }
                return new WaitingForPushDeviceDetails(this.machine);
            }
            if (event instanceof GotPushDeviceDetails) {
                return this;
            }
            return null;
        }
    }

    static abstract class ErrorEvent
    extends Event {
        final ErrorInfo reason;

        ErrorEvent(ErrorInfo reason) {
            this.reason = reason;
        }
    }

    public static abstract class Event {
    }

    public static class DeregistrationFailed
    extends ErrorEvent {
        public DeregistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class Deregistered
    extends Event {
    }

    public static class UpdatingRegistrationFailed
    extends ErrorEvent {
        public UpdatingRegistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class RegistrationUpdated
    extends Event {
    }

    public static class GettingPushDeviceDetailsFailed
    extends ErrorEvent {
        GettingPushDeviceDetailsFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class GettingDeviceRegistrationFailed
    extends ErrorEvent {
        GettingDeviceRegistrationFailed(ErrorInfo reason) {
            super(reason);
        }
    }

    public static class GotDeviceRegistration
    extends Event {
        final String deviceIdentityToken;

        GotDeviceRegistration(String token) {
            this.deviceIdentityToken = token;
        }
    }

    public static class GotPushDeviceDetails
    extends Event {
    }

    public static class CalledDeactivate
    extends Event {
        static CalledDeactivate useCustomRegistrar(boolean useCustomRegistrar, SharedPreferences prefs) {
            prefs.edit().putBoolean("ABLY_PUSH_REGISTRATION_HANDLER", useCustomRegistrar).apply();
            return new CalledDeactivate();
        }
    }

    public static class CalledActivate
    extends Event {
        public static CalledActivate useCustomRegistrar(boolean useCustomRegistrar, SharedPreferences prefs) {
            prefs.edit().putBoolean("ABLY_PUSH_REGISTRATION_HANDLER", useCustomRegistrar).apply();
            return new CalledActivate();
        }
    }
}

