/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class Message
extends BaseMessage {
    public String name;
    public JsonObject extras;
    private static final String TAG = Message.class.getName();

    public Message() {
    }

    public Message(String name, Object data) {
        this(name, data, null, null);
    }

    public Message(String name, Object data, String clientId) {
        this(name, data, clientId, null);
    }

    public Message(String name, Object data, JsonObject extras) {
        this(name, data, null, extras);
    }

    public Message(String name, Object data, String clientId, JsonObject extras) {
        this.name = name;
        this.clientId = clientId;
        this.data = data;
        this.extras = extras;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Message");
        super.getDetails(result);
        if (this.name != null) {
            result.append(" name=").append(this.name);
        }
        result.append(']');
        return result.toString();
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = super.countFields();
        if (this.name != null) {
            ++fieldCount;
        }
        if (this.extras != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        super.writeFields(packer);
        if (this.name != null) {
            packer.packString("name");
            packer.packString(this.name);
        }
        if (this.extras != null) {
            packer.packString("extras");
            Serialisation.gsonToMsgpack((JsonElement)this.extras, packer);
        }
    }

    Message readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (super.readField(unpacker, fieldName, fieldFormat)) continue;
            if (fieldName.equals("name")) {
                this.name = unpacker.unpackString();
                continue;
            }
            if (fieldName == "extras") {
                this.extras = (JsonObject)Serialisation.msgpackToGson((Value)unpacker.unpackValue());
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static Message fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new Message().readMsgpack(unpacker);
    }

    public static Message fromEncoded(JsonObject messageJson, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            Message message = (Message)Serialisation.gson.fromJson((JsonElement)messageJson, Message.class);
            message.decode(channelOptions);
            return message;
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message fromEncoded(String messageJson, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonObject jsonObject = (JsonObject)Serialisation.gson.fromJson(messageJson, JsonObject.class);
            return Message.fromEncoded(jsonObject.getAsJsonObject(), channelOptions);
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message[] fromEncodedArray(JsonArray messageArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            Message[] messages = new Message[messageArray.size()];
            for (int index = 0; index < messageArray.size(); ++index) {
                JsonElement jsonElement = messageArray.get(index);
                if (!jsonElement.isJsonObject()) {
                    throw new JsonParseException("Not all JSON elements are of type JSON Object.");
                }
                messages[index] = Message.fromEncoded(jsonElement.getAsJsonObject(), channelOptions);
            }
            return messages;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message[] fromEncodedArray(String messagesArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonArray jsonArray = (JsonArray)Serialisation.gson.fromJson(messagesArray, JsonArray.class);
            return Message.fromEncodedArray(jsonArray, channelOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static class Serializer
    extends BaseMessage.Serializer
    implements JsonSerializer<Message> {
        public JsonElement serialize(Message message, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = (JsonObject)super.serialize(message, typeOfMessage, ctx);
            if (message.name != null) {
                json.addProperty("name", message.name);
            }
            if (message.extras != null) {
                json.add("extras", (JsonElement)message.extras);
            }
            return json;
        }
    }

    public static class Batch {
        public String[] channels;
        public Message[] messages;

        public Batch(String channel, Message[] messages) {
            if (channel == null || channel.isEmpty()) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of channels");
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of messages");
            }
            this.channels = new String[]{channel};
            this.messages = messages;
        }

        public Batch(String[] channels, Message[] messages) {
            if (channels == null || channels.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of channels");
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of messages");
            }
            this.channels = channels;
            this.messages = messages;
        }

        public Batch(Collection<String> channels, Collection<Message> messages) {
            this(channels.toArray(new String[channels.size()]), messages.toArray(new Message[messages.size()]));
        }

        public void writeMsgpack(MessagePacker packer) throws IOException {
            packer.packMapHeader(2);
            packer.packString("channels");
            packer.packArrayHeader(this.channels.length);
            for (String ch : this.channels) {
                packer.packString(ch);
            }
            packer.packString("messages");
            MessageSerializer.writeMsgpackArray(this.messages, packer);
        }
    }
}

