/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import io.ably.lib.push.ActivationStateMachine;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.RegistrationToken;
import io.ably.lib.util.Log;
import java.util.WeakHashMap;

public class ActivationContext {
    protected AblyRest ably;
    protected String clientId;
    protected ActivationStateMachine activationStateMachine;
    protected LocalDevice localDevice;
    protected final SharedPreferences prefs;
    protected final Context context;
    private static WeakHashMap<Context, ActivationContext> activationContexts = new WeakHashMap();
    private static final String TAG = ActivationContext.class.getName();

    public ActivationContext(Context context) {
        this.context = context;
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    Context getContext() {
        return this.context;
    }

    SharedPreferences getPreferences() {
        return this.prefs;
    }

    public synchronized LocalDevice getLocalDevice() {
        if (this.localDevice == null) {
            this.localDevice = new LocalDevice(this);
        }
        return this.localDevice;
    }

    public synchronized void setActivationStateMachine(ActivationStateMachine activationStateMachine) {
        this.activationStateMachine = activationStateMachine;
    }

    public synchronized ActivationStateMachine getActivationStateMachine() {
        if (this.activationStateMachine == null) {
            this.activationStateMachine = new ActivationStateMachine(this);
        }
        return this.activationStateMachine;
    }

    public void setAbly(AblyRest ably) {
        this.ably = ably;
        this.clientId = ably.auth.clientId;
    }

    AblyRest getAbly() throws AblyException {
        if (this.ably != null) {
            Log.v(TAG, "getAbly(): returning existing Ably instance");
            return this.ably;
        }
        String deviceIdentityToken = this.getLocalDevice().deviceIdentityToken;
        if (deviceIdentityToken == null) {
            Log.e(TAG, "getAbly(): unable to create Ably instance using deviceIdentityToken");
            throw AblyException.fromErrorInfo(new ErrorInfo("Unable to get Ably library instance; no device identity token", 40000, 400));
        }
        Log.v(TAG, "getAbly(): returning Ably instance using deviceIdentityToken");
        this.ably = new AblyRest(deviceIdentityToken);
        return this.ably;
    }

    public boolean setClientId(String clientId) {
        boolean updated;
        boolean bl = updated = !clientId.equals(this.clientId);
        if (updated && this.localDevice != null) {
            this.localDevice.setClientId(clientId);
            if (this.localDevice.isRegistered() && this.activationStateMachine != null) {
                this.activationStateMachine.handleEvent(new ActivationStateMachine.GotPushDeviceDetails());
            }
        }
        return updated;
    }

    public void onNewRegistrationToken(RegistrationToken.Type type, String token) {
        LocalDevice localDevice = this.getLocalDevice();
        RegistrationToken previous = localDevice.getRegistrationToken();
        if (previous != null) {
            if (previous.type != type) {
                Log.e(TAG, "trying to register device with " + (Object)((Object)type) + ", but it was already registered with " + (Object)((Object)previous.type));
                return;
            }
            if (previous.token.equals(token)) {
                return;
            }
        }
        Log.v(TAG, "onNewRegistrationToken(): updating token");
        localDevice.setAndPersistRegistrationToken(new RegistrationToken(type, token));
        this.getActivationStateMachine().handleEvent(new ActivationStateMachine.GotPushDeviceDetails());
    }

    public void reset() {
        this.ably = null;
        this.getActivationStateMachine().reset();
        this.activationStateMachine = null;
        this.getLocalDevice().reset();
        this.localDevice = null;
    }

    public static ActivationContext getActivationContext(Context applicationContext) {
        return ActivationContext.getActivationContext(applicationContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivationContext getActivationContext(Context applicationContext, AblyRest ably) {
        ActivationContext activationContext;
        WeakHashMap<Context, ActivationContext> weakHashMap = activationContexts;
        synchronized (weakHashMap) {
            activationContext = activationContexts.get(applicationContext);
            if (activationContext == null) {
                Log.v(TAG, "getActivationContext(): creating new ActivationContext for this application");
                activationContext = new ActivationContext(applicationContext);
                activationContexts.put(applicationContext, activationContext);
            }
            if (ably != null) {
                activationContext.setAbly(ably);
            }
        }
        return activationContext;
    }

    void getRegistrationToken(OnCompleteListener<InstanceIdResult> listener) {
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener(listener);
    }
}

