/*
 * Decompiled with CFR 0.152.
 */
package info.solidsoft.mockito.java8;

import java.util.function.Predicate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mockito.Matchers;

public class LambdaMatcher<T>
extends BaseMatcher<T> {
    private final Matcher<T> backendMatcher;

    private LambdaMatcher(final Predicate<T> lambda, final String description) {
        this.backendMatcher = new BaseMatcher<T>(){

            public boolean matches(Object item) {
                try {
                    return lambda.test(item);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description hamcrestDesc) {
                hamcrestDesc.appendText(description);
            }
        };
    }

    public boolean matches(Object item) {
        return this.backendMatcher.matches(item);
    }

    public void describeTo(Description description) {
        this.backendMatcher.describeTo(description);
    }

    public static <T> T argLambda(Predicate<T> lambda) {
        return LambdaMatcher.argLambda(lambda, "Inline lambda expression - add description in code to get more detailed error message");
    }

    public static <T> T argLambda(Predicate<T> lambda, String description) {
        return (T)Matchers.argThat(new LambdaMatcher<T>(lambda, description));
    }
}

