/*
 * Decompiled with CFR 0.152.
 */
package info.solidsoft.mockito.java8;

import info.solidsoft.mockito.java8.LambdaAwareHandyReturnValues;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

public class AssertionMatcher<T>
extends ArgumentMatcher<T> {
    private static final LambdaAwareHandyReturnValues handyReturnValues = new LambdaAwareHandyReturnValues();
    private final Consumer<T> consumer;
    private String errorMessage;

    private AssertionMatcher(Consumer<T> consumer) {
        this.consumer = consumer;
    }

    public boolean matches(Object argument) {
        try {
            this.consumer.accept(argument);
            return true;
        }
        catch (AssertionError e) {
            this.errorMessage = ((Throwable)((Object)e)).getMessage();
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("AssertionMatcher reported: " + this.errorMessage);
    }

    public static <T> T assertArg(Consumer<T> consumer) {
        Mockito.argThat(new AssertionMatcher<T>(consumer));
        return handyReturnValues.returnForConsumerLambda(consumer);
    }
}

