/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.models.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DirectoryStructurePattern {
    private String system;
    private String owner;
    private String subOwner;
    private Integer year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private Integer second;
    private Integer milliSecond;
    private String name;
    private static final List<DepthSetter> SETTERS;

    public DirectoryStructurePattern() {
    }

    public DirectoryStructurePattern(String owner, String subOwner) {
        this.owner = owner;
        this.subOwner = subOwner;
    }

    public DirectoryStructurePattern setDefault() {
        return this.setDate(this.newDate(), DirectoryStructureDepth.MINUTE);
    }

    Date newDate() {
        return new Date();
    }

    public DirectoryStructurePattern setDate(Date date, DirectoryStructureDepth depth) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        for (DepthSetter setter : SETTERS) {
            if (setter.isDepth(depth)) {
                setter.setValue(calendar, this);
                return this;
            }
            setter.setValue(calendar, this);
        }
        return this;
    }

    public DirectoryStructurePattern setSystem(String system) {
        this.system = system;
        return this;
    }

    public DirectoryStructurePattern setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public DirectoryStructurePattern setSubOwner(String subOwner) {
        this.subOwner = subOwner;
        return this;
    }

    public DirectoryStructurePattern setYear(int year) {
        this.year = year;
        return this;
    }

    public DirectoryStructurePattern setMonth(int month) {
        if (this.between(month, 1, 12)) {
            this.month = month;
        }
        return this;
    }

    public DirectoryStructurePattern setDay(int day) {
        if (this.between(day, 1, 31)) {
            this.day = day;
        }
        return this;
    }

    public DirectoryStructurePattern setHour(int hour) {
        if (this.between(hour, 1, 24)) {
            this.hour = hour;
        }
        return this;
    }

    public DirectoryStructurePattern setMinute(int minute) {
        if (this.between(minute, 0, 59)) {
            this.minute = minute;
        }
        return this;
    }

    public DirectoryStructurePattern setSecond(int second) {
        if (this.between(second, 0, 59)) {
            this.second = second;
        }
        return this;
    }

    public DirectoryStructurePattern setMilliSecond(int msecond) {
        this.milliSecond = msecond;
        return this;
    }

    public DirectoryStructurePattern setName(String name) {
        this.name = name;
        return this;
    }

    private boolean between(int number, int from, int to) {
        return number <= to && number >= from;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTring(this.system, stringBuilder);
        this.addTring(this.owner, stringBuilder);
        this.addTring(this.subOwner, stringBuilder);
        SETTERS.forEach(setter -> setter.setValue(this, stringBuilder));
        return stringBuilder.toString();
    }

    void addTring(String string, StringBuilder stringBuilder) {
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string);
        }
    }

    public String getName() {
        return this.name;
    }

    static {
        ArrayList<DepthBase> temp = new ArrayList<DepthBase>();
        temp.add(new YearDepthSetter());
        temp.add(new MonthDepthSetter());
        temp.add(new DayDepthSetter());
        temp.add(new HourSetter());
        temp.add(new MinuteSetter());
        temp.add(new SecondSetter());
        temp.add(new MilliSecondSetter());
        SETTERS = Collections.unmodifiableList(temp);
    }

    public static enum DirectoryStructureDepth {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    static class MilliSecondSetter
    extends DepthBase
    implements DepthSetter {
        MilliSecondSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.MILLISECOND;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setMilliSecond(calendar.get(14));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.milliSecond, stringBuilder);
        }
    }

    static class SecondSetter
    extends DepthBase
    implements DepthSetter {
        SecondSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.SECOND;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setSecond(calendar.get(13));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.second, stringBuilder);
        }
    }

    static class MinuteSetter
    extends DepthBase
    implements DepthSetter {
        MinuteSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.MINUTE;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setMinute(calendar.get(12));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.minute, stringBuilder);
        }
    }

    static class HourSetter
    extends DepthBase
    implements DepthSetter {
        HourSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.HOUR;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setHour(calendar.get(10));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.hour, stringBuilder);
        }
    }

    static class DayDepthSetter
    extends DepthBase
    implements DepthSetter {
        DayDepthSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.DAY;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setDay(calendar.get(5));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.day, stringBuilder);
        }
    }

    static class MonthDepthSetter
    extends DepthBase
    implements DepthSetter {
        MonthDepthSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.MONTH;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setMonth(calendar.get(2) + 1);
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.month, stringBuilder);
        }
    }

    static class YearDepthSetter
    extends DepthBase
    implements DepthSetter {
        YearDepthSetter() {
        }

        @Override
        public boolean isDepth(DirectoryStructureDepth depth) {
            return depth == DirectoryStructureDepth.YEAR;
        }

        @Override
        public void setValue(Calendar calendar, DirectoryStructurePattern pattern) {
            pattern.setYear(calendar.get(1));
        }

        @Override
        public void setValue(DirectoryStructurePattern depth, StringBuilder stringBuilder) {
            this.addNumber(depth.year, stringBuilder);
        }
    }

    static abstract class DepthBase {
        DepthBase() {
        }

        public void addNumber(Integer number, StringBuilder stringBuilder) {
            if (number != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(number.toString());
            }
        }
    }

    static interface DepthSetter {
        public boolean isDepth(DirectoryStructureDepth var1);

        public void setValue(Calendar var1, DirectoryStructurePattern var2);

        public void setValue(DirectoryStructurePattern var1, StringBuilder var2);
    }
}

