/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.OutputFileMixin;
import picocli.codegen.util.Util;

public class ResourceConfigGenerator {
    public static void main(String ... args) {
        App app = new App();
        int exitCode = new CommandLine((Object)app).execute(args);
        if (app.exit) {
            System.exit(exitCode);
        }
    }

    public static String generateResourceConfig(CommandLine.Model.CommandSpec[] specs, String[] bundles, String[] resourceRegex) {
        Visitor visitor = new Visitor();
        visitor.bundles.addAll(Arrays.asList(bundles));
        visitor.resources.addAll(Arrays.asList(resourceRegex));
        for (CommandLine.Model.CommandSpec spec : specs) {
            visitor.visitCommandSpec(spec);
        }
        return visitor.toString();
    }

    static final class Visitor {
        Set<String> resources = new LinkedHashSet<String>();
        Set<String> bundles = new LinkedHashSet<String>();

        Visitor() {
        }

        void visitCommandSpec(CommandLine.Model.CommandSpec spec) {
            String bundle = spec.resourceBundleBaseName();
            if (bundle != null) {
                this.bundles.add(bundle);
            }
            for (CommandLine.Model.CommandSpec mixin : spec.mixins().values()) {
                this.visitCommandSpec(mixin);
            }
            for (CommandLine sub : spec.subcommands().values()) {
                this.visitCommandSpec(sub.getCommandSpec());
            }
        }

        public String toString() {
            return String.format("{%n  \"bundles\" : [%s%n  ],%n  \"resources\" : [%s%n  ]%n}%n", this.bundlesJson(), this.resourcesJson());
        }

        private StringBuilder bundlesJson() {
            return Visitor.json(this.bundles, "name");
        }

        private StringBuilder resourcesJson() {
            return Visitor.json(this.resources, "pattern");
        }

        private static StringBuilder json(Collection<String> strings, String label) {
            StringBuilder result = new StringBuilder(1024);
            for (String str : strings) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(String.format("%n    {\"%s\" : \"%s\"}", label, str));
            }
            return result;
        }
    }

    @CommandLine.Command(name="gen-resource-config", showAtFileInUsageHelp=true, sortOptions=false, description={"Generates a JSON file with the resources and resource bundles to include in the native image.", "The generated JSON file can be passed to the `-H:ResourceConfigurationFiles=/path/to/resource-config.json` option of the `native-image` GraalVM utility.", "See https://github.com/oracle/graal/blob/master/substratevm/Resources.md"}, exitCodeListHeading="%nExit Codes (if enabled with `--exit`)%n", exitCodeList={"0:Successful program execution.", "1:A runtime exception occurred while generating man pages.", "2:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc."}, footerHeading="%nExample%n", footer={"  java -cp \"myapp.jar;picocli-4.6.2.jar;picocli-codegen-4.6.2.jar\" picocli.codegen.aot.graalvm.ResourceConfigGenerator my.pkg.MyClass"}, mixinStandardHelpOptions=true, version={"picocli-codegen gen-resource-config 4.6.2"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="0..*", description={"Zero or more `@Command` classes with a resource bundle to include in the image."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Option(names={"-b", "--bundle"}, paramLabel="<bundle-base-name>", description={"Additional resource bundle(s) to be included in the image. This option may be specified multiple times with different regular expression patterns."})
        String[] bundles = new String[0];
        @CommandLine.Option(names={"-p", "--pattern"}, description={"Java regexp that matches resource(s) to be included in the image. This option may be specified multiple times with different regular expression patterns."})
        String[] resourceRegex = new String[0];
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();
        @CommandLine.Option(names={"--exit"}, negatable=true, description={"Specify `--exit` if you want the application to call `System.exit` when finished. By default, `System.exit` is not called."})
        boolean exit;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            List<CommandLine.Model.CommandSpec> specs = Util.getCommandSpecs(this.factoryClass, this.classes);
            String result = ResourceConfigGenerator.generateResourceConfig(specs.toArray(new CommandLine.Model.CommandSpec[0]), this.bundles, this.resourceRegex);
            this.outputFile.write(result);
            return 0;
        }
    }
}

