/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero.relocated.org.objenesis.strategy;

import info.jerrinot.subzero.relocated.org.objenesis.instantiator.ObjectInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.android.Android10Instantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.android.Android17Instantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.android.Android18Instantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.basic.AccessibleInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.gcj.GCJInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.jrockit.JRockitLegacyInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.perc.PercInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import info.jerrinot.subzero.relocated.org.objenesis.strategy.BaseInstantiatorStrategy;
import info.jerrinot.subzero.relocated.org.objenesis.strategy.PlatformDescription;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine()) {
                if (Serializable.class.isAssignableFrom(type)) {
                    return new ObjectInputStreamInstantiator<T>(type);
                }
                return new AccessibleInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            if (!(!PlatformDescription.VM_VERSION.startsWith("1.4") || PlatformDescription.VENDOR_VERSION.startsWith("R") || PlatformDescription.VM_INFO != null && PlatformDescription.VM_INFO.startsWith("R25.1") && PlatformDescription.VM_INFO.startsWith("R25.2"))) {
                return new JRockitLegacyInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

