/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero.internal.strategy;

import com.hazelcast.core.HazelcastInstance;
import info.jerrinot.subzero.internal.ClassLoaderUtils;
import info.jerrinot.subzero.internal.IdGeneratorUtils;
import info.jerrinot.subzero.internal.strategy.DelegatingClassResolver;
import info.jerrinot.subzero.internal.strategy.KryoContext;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.Kryo;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.ReferenceResolver;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.io.Input;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.io.InputChunked;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.io.Output;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.io.OutputChunked;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.util.DefaultStreamFactory;
import info.jerrinot.subzero.relocated.org.objenesis.strategy.StdInstantiatorStrategy;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class KryoStrategy<T> {
    private static final int BUFFER_SIZE = Integer.getInteger("subzero.buffer.size.kb", 16) * 1024;
    private static final boolean IGNORE_HAZELCAST_CLASSLOADER = Boolean.getBoolean("subzero.classloading.ignore");
    private static final String DEFAULT_REFERENCE_RESOLVER_CLASS = "info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.util.MapReferenceResolver";
    private static final String REFERENCE_RESOLVER_CLASS_SYSTEM_PROPERTY = "subzero.referenceresolver.class";
    private HazelcastInstance hazelcastInstance;
    private final ThreadLocal<KryoContext> KRYOS = new ThreadLocal<KryoContext>(){

        @Override
        protected KryoContext initialValue() {
            Kryo kryo = KryoStrategy.this.newKryoInstance();
            OutputChunked output = new OutputChunked(BUFFER_SIZE);
            InputChunked input = new InputChunked(BUFFER_SIZE);
            return new KryoContext(kryo, input, output);
        }
    };

    private Kryo newKryoInstance() {
        Kryo kryo;
        if (IGNORE_HAZELCAST_CLASSLOADER) {
            kryo = new Kryo(KryoStrategy.createReferenceResolver());
        } else {
            ClassLoader classLoader = ClassLoaderUtils.getConfiguredClassLoader(this.hazelcastInstance);
            DelegatingClassResolver classResolver = new DelegatingClassResolver(classLoader);
            ReferenceResolver referenceResolver = KryoStrategy.createReferenceResolver();
            DefaultStreamFactory defaultStreamFactory = new DefaultStreamFactory();
            kryo = new Kryo(classResolver, referenceResolver, defaultStreamFactory);
        }
        this.registerCustomSerializers(kryo);
        kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        return kryo;
    }

    HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public abstract void registerCustomSerializers(Kryo var1);

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void write(OutputStream out, T object) {
        KryoContext kryoContext = this.KRYOS.get();
        OutputChunked output = kryoContext.getOutputChunked();
        output.setOutputStream(out);
        this.writeObject(kryoContext.getKryo(), output, object);
        output.endChunks();
        output.flush();
    }

    abstract void writeObject(Kryo var1, Output var2, T var3);

    public T read(InputStream in) {
        KryoContext kryoContext = this.KRYOS.get();
        InputChunked input = kryoContext.getInputChunked();
        input.setInputStream(in);
        return this.readObject(kryoContext.getKryo(), input);
    }

    abstract T readObject(Kryo var1, Input var2);

    public void destroy(HazelcastInstance hazelcastInstance) {
        IdGeneratorUtils.instanceDestroyed(hazelcastInstance);
    }

    public abstract int newId();

    private static ReferenceResolver createReferenceResolver() {
        String referenceResolverClass = System.getProperty(REFERENCE_RESOLVER_CLASS_SYSTEM_PROPERTY, DEFAULT_REFERENCE_RESOLVER_CLASS);
        try {
            Class<?> resolverClass = Class.forName(referenceResolverClass);
            return (ReferenceResolver)resolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("could not create ReferenceResolver with class %s", referenceResolverClass), e);
        }
    }
}

